/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.authentication;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.auth.SessionTimeoutException;
import org.rhq.enterprise.server.core.StartupLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class SessionAccessServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean serverInitialized;
        response.setContentType("text/plain");
        response.addHeader("Pragma", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Cache-Control", "must-revalidate");
        response.addHeader("Expires", "Mon, 8 Aug 2006 10:00:00 GMT");
        try {
            serverInitialized = LookupUtil.getStartupLocal().isInitialized();
        }
        catch (Throwable t) {
            serverInitialized = false;
        }
        if (!serverInitialized) {
            response.setHeader("Retry-After", "30");
            response.sendError(503, "Server is not ready - still booting up");
            return;
        }
        HttpSession session = request.getSession();
        String sessionWebUserUpdate = request.getHeader("rhq-webuser-update");
        String sessionLastAccessUpdate = request.getHeader("rhq-last-access-update");
        if (sessionLastAccessUpdate != null) {
            PrintWriter writer = response.getWriter();
            writer.print("success");
            return;
        }
        WebUser webUser = SessionUtils.getWebUser((HttpSession)session);
        if (webUser != null && webUser.getSubject() != null) {
            if (sessionWebUserUpdate != null && !sessionWebUserUpdate.trim().isEmpty()) {
                try {
                    Subject currentSubject = SessionManager.getInstance().getSubject(Integer.valueOf(sessionWebUserUpdate).intValue());
                    if (currentSubject != null && webUser.getSubject().getName().equalsIgnoreCase(currentSubject.getName())) {
                        webUser = new WebUser(currentSubject);
                        SessionUtils.setWebUser((HttpSession)session, (WebUser)webUser);
                    }
                }
                catch (SessionNotFoundException snfe) {
                }
                catch (NumberFormatException e) {
                }
                catch (SessionTimeoutException e) {
                    // empty catch block
                }
            }
            Subject subject = webUser.getSubject();
            try {
                SessionManager.getInstance().getSubject(subject.getSessionId().intValue());
                long lastAccess = SessionManager.getInstance().getLastAccess(subject.getSessionId().intValue());
                PrintWriter writer = response.getWriter();
                String output = subject.getId() + ":" + webUser.getSessionId() + ":" + lastAccess;
                writer.print(output);
            }
            catch (SessionNotFoundException snfe) {
                session.removeAttribute("u");
                SessionUtils.setWebUser((HttpSession)session, null);
            }
            catch (SessionTimeoutException ste) {
                session.removeAttribute("u");
                SessionUtils.setWebUser((HttpSession)session, null);
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean serverInitialized;
        response.setContentType("application/json");
        response.addHeader("Pragma", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Cache-Control", "must-revalidate");
        response.addHeader("Expires", "Mon, 8 Aug 2006 10:00:00 GMT");
        String startupError = null;
        try {
            StartupLocal startupBean = LookupUtil.getStartupLocal();
            serverInitialized = startupBean.isInitialized();
            startupError = startupBean.getError();
        }
        catch (Throwable t) {
            serverInitialized = false;
        }
        PrintWriter out = response.getWriter();
        out.println("{");
        out.println("  \"serverInitialized\": " + serverInitialized + ",");
        out.println("  \"startupError\": " + (startupError == null ? "null" : "\"" + startupError + "\""));
        out.println("}");
    }
}

