/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.configuration;

import javax.faces.application.FacesMessage;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.gui.util.FacesContextUtility;

public abstract class AbstractAddNewOpenMapMemberPropertyUIBean {
    private static final String SUCCESS_OUTCOME = "success";
    private static final String FAILURE_OUTCOME = "failure";
    private String propertyName;
    private String propertyValue;

    protected abstract Configuration getConfiguration();

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    public String addProperty() {
        String mapName = FacesContextUtility.getRequiredRequestParameter((String)"mapName");
        PropertyMap propertyMap = this.getConfiguration().getMap(mapName);
        if (propertyMap == null) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Configuration does not contain a map named '" + mapName + "'."));
            return FAILURE_OUTCOME;
        }
        String propertyName = this.propertyName.trim();
        if (propertyMap.getMap().containsKey(propertyName)) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Map '" + mapName + "' already contains a property named '" + propertyName + "'."));
            return FAILURE_OUTCOME;
        }
        PropertySimple propertySimple = new PropertySimple(propertyName, (Object)this.propertyValue);
        propertySimple.setOverride(Boolean.valueOf(true));
        propertyMap.put((Property)propertySimple);
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Property '" + propertySimple.getName() + "' added to map '" + mapName + "'."));
        return SUCCESS_OUTCOME;
    }

    public String cancel() {
        return SUCCESS_OUTCOME;
    }
}

