/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.configuration.resource;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.application.FacesMessage;
import javax.faces.event.ValueChangeEvent;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.RawConfiguration;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationFormat;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.gui.common.upload.FileUploadUIBean;
import org.rhq.enterprise.gui.configuration.AbstractConfigurationUIBean;
import org.rhq.enterprise.gui.configuration.resource.ExistingResourceConfigurationUIBean;
import org.rhq.enterprise.gui.configuration.resource.RawConfigDirectory;
import org.rhq.enterprise.gui.configuration.resource.RawConfigUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.richfaces.model.UploadItem;

public class ExistingResourceConfigurationUIBean
extends AbstractConfigurationUIBean {
    public static final String MANAGED_BEAN_NAME = "ExistingResourceConfigurationUIBean";
    private static final boolean STRUCTURED_MODE = true;
    private static final boolean RAW_MODE = false;
    private boolean mode = true;
    private Collection<RawConfigDirectory> rawConfigDirectories;
    private FileUploadUIBean fileUploader = new FileUploadUIBean();
    private String modalEditorContents;
    private int numberOfModifiedFiles;
    protected ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
    private final Log log = LogFactory.getLog(AbstractConfigurationUIBean.class);
    private Integer resourceId = null;
    private static final long serialVersionUID = 4837157548556168146L;
    String selectedPath;
    private TreeMap<String, RawConfiguration> raws;
    TreeMap<String, RawConfiguration> modified = new TreeMap();
    RawConfiguration current = null;

    public ExistingResourceConfigurationUIBean() {
        this.removeSessionScopedBeanIfInView("/rhq/resource/configuration/view.xhtml", ExistingResourceConfigurationUIBean.class);
    }

    public void begin() {
        if (this.isRawSupported() || this.isStructuredAndRawSupported()) {
            this.initConfigDirectories();
        } else {
            this.rawConfigDirectories = Collections.emptyList();
        }
    }

    private void initConfigDirectories() {
        HashMap<String, RawConfigDirectory> dirs = new HashMap<String, RawConfigDirectory>();
        for (RawConfiguration rawConfig : this.getConfiguration().getRawConfigurations()) {
            String parentDirPath = this.getParentDir(rawConfig);
            RawConfigDirectory dir = (RawConfigDirectory)dirs.get(parentDirPath);
            if (dir == null) {
                dir = new RawConfigDirectory();
                dir.setPath(parentDirPath);
            }
            dir.addRawConfig(rawConfig);
            dirs.put(parentDirPath, dir);
        }
        this.rawConfigDirectories = dirs.values();
    }

    private String getParentDir(RawConfiguration rawConfig) {
        File file = new File(rawConfig.getPath());
        return file.getParentFile().getAbsolutePath();
    }

    public String editConfiguration() {
        this.mode = true;
        return "success";
    }

    public String editRawConfiguration() {
        this.mode = false;
        return "success";
    }

    public void changeTabs(ValueChangeEvent event) {
        if (event.getNewValue().equals("rawTab")) {
            this.switchToRaw();
            this.mode = false;
        } else if (event.getNewValue().equals("structuredTab")) {
            this.switchToStructured();
            this.mode = true;
        }
    }

    public String switchToRaw() {
        Configuration configuration = LookupUtil.getConfigurationManager().translateResourceConfiguration(EnterpriseFacesContextUtility.getSubject(), this.getResourceId(), this.getConfiguration(), true);
        this.setConfiguration(configuration);
        for (RawConfiguration raw : configuration.getRawConfigurations()) {
            this.getRaws().put(raw.getPath(), raw);
        }
        this.current = null;
        this.setConfiguration(configuration);
        this.updateModifiedCache();
        this.mode = false;
        return null;
    }

    private void updateModifiedCache() {
        Configuration configuration = this.getConfiguration();
        for (RawConfiguration updatedRaw : configuration.getRawConfigurations()) {
            RawConfiguration cachedRaw = (RawConfiguration)this.modified.get(updatedRaw.getPath());
            if (cachedRaw == null || updatedRaw.getSha256().equals(cachedRaw.getSha256())) continue;
            this.modified.remove(cachedRaw.getPath());
        }
    }

    public String switchToStructured() {
        Configuration configuration = LookupUtil.getConfigurationManager().translateResourceConfiguration(EnterpriseFacesContextUtility.getSubject(), this.getResourceId(), this.getMergedConfiguration(), false);
        for (Property property : configuration.getAllProperties().values()) {
            property.setConfiguration(configuration);
        }
        for (RawConfiguration raw : configuration.getRawConfigurations()) {
            this.getRaws().put(raw.getPath(), raw);
            this.setConfiguration(configuration);
        }
        this.current = null;
        this.setConfiguration(configuration);
        for (RawConfiguration raw : configuration.getRawConfigurations()) {
            System.out.println(raw.getPath() + " -\n" + raw.getContents() + "\n");
        }
        this.updateModifiedCache();
        this.mode = true;
        return null;
    }

    public String updateConfiguration() {
        return this.updateConfiguration(true);
    }

    public String updateRawConfiguration() {
        return this.updateConfiguration(false);
    }

    public void saveModalEditorContents() {
        this.setCurrentContents(this.modalEditorContents);
    }

    public String updateConfiguration(boolean fromStructured) {
        int resourceId = EnterpriseFacesContextUtility.getResource().getId();
        Configuration mergedConfiguration = this.getMergedConfiguration();
        ResourceConfigurationUpdate updateRequest = this.configurationManager.updateStructuredOrRawConfiguration(EnterpriseFacesContextUtility.getSubject(), resourceId, mergedConfiguration, fromStructured);
        if (updateRequest != null) {
            switch (1.$SwitchMap$org$rhq$core$domain$configuration$ConfigurationUpdateStatus[updateRequest.getStatus().ordinal()]) {
                case 1: 
                case 2: {
                    FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Configuration update request with id " + updateRequest.getId() + " has been sent to the Agent."));
                    this.clearConfiguration();
                    return "success";
                }
                case 3: {
                    FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Configuration update request with id " + updateRequest.getId() + " failed."), (String)updateRequest.getErrorMessage());
                    if (null != mergedConfiguration) {
                        for (RawConfiguration raw : mergedConfiguration.getRawConfigurations()) {
                            String message = raw.errorMessage;
                            if (message == null) continue;
                            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)raw.getPath(), (String)message);
                        }
                    }
                    return "failure";
                }
                case 4: {
                    FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"No changes were made to the configuration, so no update request has been sent to the Agent.");
                    this.clearConfiguration();
                    return "success";
                }
            }
        }
        return "failure";
    }

    public String finishAddMap() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Map added.");
        return "success";
    }

    public String finishEditMap() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Map updated.");
        return "success";
    }

    protected int getConfigurationDefinitionKey() {
        return EnterpriseFacesContextUtility.getResource().getResourceType().getId();
    }

    @Nullable
    protected ConfigurationDefinition lookupConfigurationDefinition() {
        int resourceTypeId = EnterpriseFacesContextUtility.getResource().getResourceType().getId();
        ConfigurationDefinition configurationDefinition = this.configurationManager.getResourceConfigurationDefinitionForResourceType(EnterpriseFacesContextUtility.getSubject(), resourceTypeId);
        return configurationDefinition;
    }

    protected int getConfigurationKey() {
        return EnterpriseFacesContextUtility.getResource().getId();
    }

    @Nullable
    protected Configuration lookupConfiguration() {
        int resourceId;
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ResourceConfigurationUpdate configurationUpdate = this.configurationManager.getLatestResourceConfigurationUpdate(subject, resourceId = EnterpriseFacesContextUtility.getResource().getId());
        Configuration configuration = configurationUpdate != null ? configurationUpdate.getConfiguration() : null;
        return configuration;
    }

    public String commit() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        LookupUtil.getConfigurationManager().updateResourceConfiguration(subject, this.getResourceId(), this.getMergedConfiguration());
        return "/rhq/resource/configuration/view.xhtml?id=" + this.getResourceId();
    }

    private Configuration getMergedConfiguration() {
        for (RawConfiguration raw : this.getModified().values()) {
            this.getRaws().put(raw.getPath(), raw);
            this.log.error((Object)("Just merged in raw path =[" + raw.getPath() + "]"));
            this.log.error((Object)("                   file =[" + new String(raw.getContents()) + "]"));
        }
        this.getConfiguration().getRawConfigurations().clear();
        this.getConfiguration().getRawConfigurations().addAll(this.getRaws().values());
        return this.getConfiguration();
    }

    public String editCurrent() {
        RawConfiguration editedRaw = this.getCurrent();
        RawConfiguration originalRaw = (RawConfiguration)this.raws.get(editedRaw.getPath());
        if (editedRaw.getSha256().equals(originalRaw.getSha256())) {
            --this.numberOfModifiedFiles;
            RawConfigUIBean rawUIBean = this.findRawConfigUIBeanByPath(editedRaw.getPath());
            this.getModified().remove(editedRaw.getPath());
        } else {
            ++this.numberOfModifiedFiles;
        }
        return null;
    }

    public void undoEdit(String path) {
        this.modified.remove(path);
        RawConfigUIBean bean = this.findRawConfigUIBeanByPath(path);
        if (bean != null) {
            // empty if block
        }
    }

    public int getConfigId() {
        return this.getConfiguration().getId();
    }

    private ConfigurationFormat getConfigurationFormat() {
        return this.getConfigurationDefinition().getConfigurationFormat();
    }

    public RawConfiguration getCurrent() {
        if (null == this.current) {
            Iterator iterator = this.getRaws().values().iterator();
            if (iterator.hasNext()) {
                this.current = (RawConfiguration)iterator.next();
            } else {
                this.current = new RawConfiguration();
                this.current.setPath("/dev/null");
                String sha256 = new MessageDigestGenerator("SHA-256").calcDigestString("");
                this.current.setContents("", sha256);
            }
        }
        return this.current;
    }

    public String getCurrentContents() {
        return new String(this.getCurrent().getContents());
    }

    public String getCurrentPath() {
        return this.getCurrent().getPath();
    }

    public String getModalEditorHeader() {
        return this.getCurrentPath();
    }

    public String getModalEditorContents() {
        if (this.modalEditorContents == null) {
            this.modalEditorContents = this.getCurrentContents();
        }
        return this.modalEditorContents;
    }

    public void setModalEditorContents(String contents) {
        this.modalEditorContents = contents;
    }

    public TreeMap<String, RawConfiguration> getModified() {
        if (this.modified == null) {
            this.modified = new TreeMap();
        }
        return this.modified;
    }

    public String getSelectedTab() {
        if (this.mode) {
            return "structuredTab";
        }
        return "rawTab";
    }

    public void setSelectedTab(String tab) {
        this.mode = tab.equals("structuredTab");
    }

    public Object[] getPaths() {
        return this.getRaws().keySet().toArray();
    }

    public int getResourceId() {
        if (this.resourceId == null) {
            this.resourceId = EnterpriseFacesContextUtility.getResource().getId();
        }
        return this.resourceId;
    }

    public boolean isStructuredMode() {
        return this.mode;
    }

    public boolean isRawMode() {
        return !this.mode;
    }

    public boolean isDisplayChangedFilesLabel() {
        if (this.isStructuredMode()) {
            return false;
        }
        if (this.isRawSupported()) {
            return true;
        }
        return this.isRawMode();
    }

    public String getModifiedFilesMsg() {
        if (!this.isDisplayChangedFilesLabel() || this.numberOfModifiedFiles == 0) {
            return "";
        }
        if (this.numberOfModifiedFiles == 1) {
            return "1 file changed in this configuration";
        }
        return this.numberOfModifiedFiles + " files changed in this configuration";
    }

    public boolean isModified(String path) {
        return this.getModified().keySet().contains(path);
    }

    public boolean isRawSupported() {
        return this.getConfigurationDefinition().getConfigurationFormat() == ConfigurationFormat.RAW;
    }

    public boolean isStructuredSupported() {
        return this.getConfigurationDefinition().getConfigurationFormat() == ConfigurationFormat.STRUCTURED;
    }

    public boolean isStructuredAndRawSupported() {
        return this.getConfigurationDefinition().getConfigurationFormat() == ConfigurationFormat.STRUCTURED_AND_RAW;
    }

    public boolean isFileUploadAvailable() {
        return this.isRawSupported() || this.isStructuredAndRawSupported() && this.isRawMode();
    }

    public void select(String s) {
        this.selectedPath = s;
        this.setCurrentPath(this.selectedPath);
        this.setCurrentContents(this.getCurrentContents());
        this.modalEditorContents = this.getCurrentContents();
    }

    public void setCurrentContents(String updated) {
        String original = new String(this.getCurrent().getContents());
        if (!updated.equals(original)) {
            this.current = this.current.deepCopy(false);
            String sha256 = new MessageDigestGenerator("SHA-256").calcDigestString(updated);
            this.current.setContents(updated, sha256);
            this.markCurrentRawConfigUIBeanModified();
            this.getModified().put(this.current.getPath(), this.current);
        }
    }

    private void markCurrentRawConfigUIBeanModified() {
        RawConfigUIBean bean = this.findRawConfigUIBeanByPath(this.current.getPath());
        if (bean != null) {
            // empty if block
        }
    }

    private RawConfigUIBean findRawConfigUIBeanByPath(String path) {
        for (RawConfigDirectory dir : this.rawConfigDirectories) {
            for (RawConfigUIBean bean : dir.getRawConfigUIBeans()) {
                if (!bean.getPath().equals(this.current.getPath())) continue;
                return bean;
            }
        }
        return null;
    }

    public void setCurrentPath(String path) {
        RawConfiguration raw = (RawConfiguration)this.getModified().get(path);
        if (null == raw) {
            raw = (RawConfiguration)this.getRaws().get(path);
        }
        if (null != raw) {
            this.current = raw;
        }
    }

    public void setModified(RawConfiguration raw) {
        this.getModified().put(raw.getPath(), raw);
    }

    public String download() {
        try {
            File file = new File(this.getCurrentPath());
            HttpServletResponse response = FacesContextUtility.getResponse();
            response.setHeader("Content-Disposition", "attachment;filename=" + file.getName());
            ServletOutputStream ostream = response.getOutputStream();
            ostream.write(this.getCurrentContents().getBytes());
            ostream.flush();
            ostream.close();
            FacesContextUtility.getFacesContext().responseComplete();
            return null;
        }
        catch (IOException e) {
            this.log.error((Object)("Failed to complete download request for " + this.getCurrentPath()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String update() {
        return "/rhq/resource/configuration/edit-raw.xhtml?currentResourceId=" + this.getResourceId();
    }

    public String completeUpload() {
        try {
            if (this.fileUploader.getFileItem() != null) {
                UploadItem fileItem = this.fileUploader.getFileItem();
                if (fileItem.isTempFile()) {
                    this.setCurrentContents(FileUtils.readFileToString((File)fileItem.getFile()));
                } else {
                    this.setCurrentContents(new String(fileItem.getData()));
                }
                this.fileUploader.clear();
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void dumpProperties(Configuration conf, Log log) {
        for (String key : conf.getAllProperties().keySet()) {
            log.error((Object)("property=" + conf.getAllProperties().get(key)));
        }
    }

    void populateRaws() {
        Set rawConfigurations = this.getConfiguration().getRawConfigurations();
        for (RawConfiguration raw : rawConfigurations) {
            this.raws.put(raw.getPath(), raw);
        }
    }

    public void setRaws(TreeMap<String, RawConfiguration> raws) {
        this.raws = raws;
    }

    public TreeMap<String, RawConfiguration> getRaws() {
        if (null == this.raws) {
            this.raws = new TreeMap();
            this.populateRaws();
        }
        return this.raws;
    }
}

