/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ContentSourceSyncResultsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ContentSourceSyncResultsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ContentSourceSyncResultsUIBean";

    public String deleteSelectedContentSourceSyncResults() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedContentSourceSyncResults();
        int[] ids = this.getIntegerArray(selected);
        if (ids != null && ids.length > 0) {
            try {
                ContentSourceManagerLocal contentSourceManager = LookupUtil.getContentSourceManager();
                contentSourceManager.deleteContentSourceSyncResults(subject, ids);
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted [" + ids.length + "] content source sync results."));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete content source sync results.", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ContentSourceSyncResultsDataModel(this, PageControlView.ContentSourceSyncResultsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedContentSourceSyncResults() {
        return FacesContextUtility.getRequest().getParameterValues("selectedContentSourceSyncResults");
    }

    private int[] getIntegerArray(String[] input) {
        if (input == null) {
            return new int[0];
        }
        int[] output = new int[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

