/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.group.inventory;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.util.MessageResources;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.enterprise.gui.legacy.action.WorkflowPrepareAction;
import org.rhq.enterprise.gui.legacy.action.resource.group.inventory.GroupForm;
import org.rhq.enterprise.gui.legacy.util.BizappUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class NewGroupFormPrepareAction
extends WorkflowPrepareAction {
    public ActionForward workflow(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GroupForm newForm = (GroupForm)form;
        MessageResources res = this.getResources(request);
        Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
        ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
        HttpSession session = request.getSession();
        Integer[] resourceIds = (Integer[])session.getAttribute("ResourceIds");
        if (resourceIds != null) {
            newForm.setResourceIds(resourceIds);
            boolean commonResourceType = false;
            Integer resourceTypeId = (Integer)session.getAttribute("ResourceType");
            if (resourceTypeId != null) {
                if (!resourceTypeManager.ensureResourceType(subject, resourceTypeId, resourceIds)) {
                    ResourceType compatibleResourceType = resourceTypeManager.getResourceTypeById(subject, resourceTypeId.intValue());
                    newForm.setResourceTypeName(compatibleResourceType.getName());
                    newForm.setResourceTypeId(resourceTypeId);
                    newForm.setGroupCategory(GroupCategory.COMPATIBLE);
                    return null;
                }
            } else {
                newForm.setResourceTypeName(res.getMessage("dash.home.DisplayCategory.group.plat.server.service"));
                newForm.setGroupCategory(GroupCategory.MIXED);
                return null;
            }
        }
        List platformTypes = resourceTypeManager.getUtilizedResourceTypesByCategory(subject, ResourceCategory.PLATFORM, null);
        List serverTypes = resourceTypeManager.getUtilizedResourceTypesByCategory(subject, ResourceCategory.SERVER, null);
        List serviceTypes = resourceTypeManager.getUtilizedResourceTypesByCategory(subject, ResourceCategory.SERVICE, null);
        List groupTypes = BizappUtils.buildGroupTypes((HttpServletRequest)request);
        newForm.setPlatformTypes(platformTypes);
        newForm.setServerTypes(serverTypes);
        newForm.setServiceTypes(serviceTypes);
        newForm.setGroupTypes(groupTypes);
        return null;
    }
}

