/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.group.inventory;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.resource.group.inventory.RemoveGroupResourcesForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupUpdateException;
import org.rhq.enterprise.server.util.LookupUtil;

public class RemoveAction
extends BaseAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog(RemoveAction.class);
        RemoveGroupResourcesForm removeForm = (RemoveGroupResourcesForm)form;
        Integer groupId = removeForm.getGroupId();
        String category = removeForm.getCategory();
        Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
        HashMap<String, Object> forwardParams = new HashMap<String, Object>(2);
        forwardParams.put("groupId", groupId);
        forwardParams.put("category", category);
        try {
            String[] resourceIdStrings = removeForm.getResources();
            if (resourceIdStrings == null || resourceIdStrings.length == 0) {
                return this.returnSuccess(request, mapping, forwardParams);
            }
            int[] resourceIds = new int[resourceIdStrings.length];
            for (int i = 0; i < resourceIds.length; ++i) {
                resourceIds[i] = Integer.parseInt(resourceIdStrings[i]);
            }
            ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
            groupManager.removeResourcesFromGroup(subject, groupId.intValue(), resourceIds);
            return this.returnSuccess(request, mapping, forwardParams);
        }
        catch (ResourceGroupUpdateException rgue) {
            log.debug((Object)"group update failed:", (Throwable)rgue);
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.group.inventory.error.GroupUpdateError", (String)rgue.getMessage());
            return this.returnFailure(request, mapping, forwardParams);
        }
        catch (ResourceGroupNotFoundException raee) {
            log.debug((Object)"group update failed:", (Throwable)raee);
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.group.inventory.error.GroupNotFound");
            return this.returnFailure(request, mapping, forwardParams);
        }
    }
}

