/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.taglib.display;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.gui.legacy.taglib.display.BaseDecorator;
import org.rhq.enterprise.gui.legacy.taglib.display.ColumnDecorator;
import org.rhq.enterprise.gui.legacy.taglib.display.ColumnTag;
import org.rhq.enterprise.gui.legacy.util.TaglibUtils;

public class PathDecorator
extends BaseDecorator {
    private static Log log = LogFactory.getLog((String)PathDecorator.class.getName());
    private boolean strict = false;
    private int postChars;
    private int preChars;
    private String styleClass = null;

    public String decorate(Object columnValue) {
        String shortPath;
        String realPath = columnValue.toString();
        if (realPath.equals(shortPath = TaglibUtils.shortenPath((String)columnValue.toString(), (int)this.preChars, (int)this.postChars, (boolean)this.strict))) {
            return realPath;
        }
        if (this.styleClass == null) {
            return shortPath;
        }
        return "<a href=\"#\" class=\"" + this.styleClass + "\">" + shortPath + "<span>" + realPath + "</span></a>";
    }

    public int doStartTag() throws JspTagException {
        ColumnTag ancestorTag = (ColumnTag)TagSupport.findAncestorWithClass((Tag)this, ColumnTag.class);
        if (ancestorTag == null) {
            throw new JspTagException("A valueDecorator must be used within a ColumnTag.");
        }
        ancestorTag.setDecorator((ColumnDecorator)this);
        return 1;
    }

    public void release() {
        this.styleClass = null;
        super.release();
    }

    public int getPostChars() {
        return this.postChars;
    }

    public void setPostChars(int postChars) {
        this.postChars = postChars;
    }

    public int getPreChars() {
        return this.preChars;
    }

    public void setPreChars(int preChars) {
        this.preChars = preChars;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }
}

