/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.measurement.schedule.resource;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.common.time.DurationComponent;
import org.rhq.enterprise.gui.measurement.schedule.resource.ListResourceMeasurementScheduleUIBean;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListResourceMeasurementScheduleUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ListResourceMeasurementScheduleUIBean";
    private MeasurementScheduleManagerLocal measurementScheduleManager = LookupUtil.getMeasurementScheduleManager();
    private DurationComponent duration;

    public DurationComponent getDuration() {
        return this.duration;
    }

    public void setDuration(DurationComponent duration) {
        this.duration = duration;
    }

    public String disableSelected() {
        int resourceId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class);
        int[] measurementDefinitionIds = this.getSelectedResourceScheduleList();
        try {
            this.measurementScheduleManager.disableSchedulesForResource(this.getSubject(), resourceId, measurementDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Disabled " + measurementDefinitionIds.length + " schedules."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to disable selected schedules.", (Throwable)e);
        }
        return "success";
    }

    public String enableSelected() {
        int resourceId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class);
        int[] measurementDefinitionIds = this.getSelectedResourceScheduleList();
        try {
            this.measurementScheduleManager.enableSchedulesForResource(this.getSubject(), resourceId, measurementDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Enabled " + measurementDefinitionIds.length + " schedules."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to enable selected schedules.", (Throwable)e);
        }
        return "success";
    }

    public String enableAndSetSelected() {
        long collectionInterval = this.duration.getMillis();
        int resourceId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class);
        int[] measurementDefinitionIds = this.getSelectedResourceScheduleList();
        try {
            this.measurementScheduleManager.updateSchedulesForResource(this.getSubject(), resourceId, measurementDefinitionIds, collectionInterval);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Enabled and set " + measurementDefinitionIds.length + " schedules."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to enabled and set selected schedules.", (Throwable)e);
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new A(this, PageControlView.ResourceMeasurementScheduleList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private int[] getSelectedResourceScheduleList() {
        String[] resourceSchedules = FacesContextUtility.getRequest().getParameterValues("selectedResourceSchedules");
        return StringUtility.getIntArray((String[])resourceSchedules);
    }

    static /* synthetic */ MeasurementScheduleManagerLocal access$000(ListResourceMeasurementScheduleUIBean x0) {
        return x0.measurementScheduleManager;
    }
}

