/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.resource.flyweight.AutoGroupCompositeFlyweight;
import org.rhq.core.domain.resource.flyweight.ResourceFlyweight;
import org.rhq.core.domain.resource.group.ClusterKey;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.util.sort.HumaneStringComparator;
import org.rhq.enterprise.gui.navigation.resource.ResourceTreeNode;

public class ResourceGroupTreeNode
implements Comparable<ResourceGroupTreeNode> {
    private final Log log = LogFactory.getLog(ResourceGroupTreeNode.class);
    private static ResourceGroupTreeNode[] CHILDREN_ABSENT = new ResourceGroupTreeNode[0];
    private ClusterKey clusterKey;
    private TreeSet<ResourceGroupTreeNode> children = new TreeSet();
    private List<ResourceTreeNode> members = new ArrayList();
    private Object level;
    private String shortPath;
    private ResourceGroupTreeNode parent;

    public ResourceGroupTreeNode(Object level, ResourceGroupTreeNode parent) {
        this.level = level;
        this.parent = parent;
    }

    public ClusterKey getClusterKey() {
        return this.clusterKey;
    }

    public void setClusterKey(ClusterKey clusterKey) {
        this.clusterKey = clusterKey;
    }

    public void addMembers(Set<ResourceTreeNode> members) {
        this.members.addAll(members);
    }

    public void addMember(ResourceTreeNode member) {
        this.members.add(member);
    }

    public TreeSet<ResourceGroupTreeNode> getChildren() {
        return this.children;
    }

    public List<ResourceTreeNode> getMembers() {
        return this.members;
    }

    public synchronized TreeSet<ResourceGroupTreeNode> getNodes() {
        return this.children;
    }

    public Object getData() {
        return this.level;
    }

    public ResourceGroupTreeNode getParent() {
        return this.parent;
    }

    public void setParent(ResourceGroupTreeNode parent) {
        this.parent = parent;
    }

    public String getNodeType() {
        if (this.level instanceof ResourceGroup) {
            return "ResourceGroup";
        }
        if (this.level instanceof AutoGroupCompositeFlyweight) {
            return "AutoGroupComposite";
        }
        if (this.level instanceof ResourceFlyweight) {
            return "Resource";
        }
        return this.level.getClass().getSimpleName();
    }

    public String toString() {
        if (this.level instanceof ResourceGroup) {
            ResourceGroup group = (ResourceGroup)this.level;
            return group.getName();
        }
        if (this.level instanceof AutoGroupCompositeFlyweight) {
            AutoGroupCompositeFlyweight ag = (AutoGroupCompositeFlyweight)this.level;
            if (ag.getResourceType() != null) {
                return ag.getResourceType().getName();
            }
            if (ag.getSubcategory() != null) {
                return ag.getSubcategory();
            }
        }
        return this.level.toString();
    }

    @Override
    public int compareTo(ResourceGroupTreeNode that) {
        try {
            return HumaneStringComparator.DEFAULT.compare(this.toString(), that.toString());
        }
        catch (Exception e) {
            this.log.warn((Object)("Couldn't compare: " + this.toString() + " || " + that + " - cause: " + e));
            return this.toString().compareTo(that.toString());
        }
    }

    public void addChildren(Collection<ResourceGroupTreeNode> resourceGroupTreeNodes) {
        this.children.addAll(resourceGroupTreeNodes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceGroupTreeNode that = (ResourceGroupTreeNode)o;
        return this.level.equals(that.level);
    }

    public int hashCode() {
        return this.level.hashCode();
    }
}

