/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.operation.history.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.operation.history.resource.ResourceOperationPendingHistoryUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ResourceOperationPendingHistoryUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ResourceOperationPendingHistoryUIBean";
    private OperationManagerLocal manager = LookupUtil.getOperationManager();
    private ResourceOperationHistory oldestInProgressResourceOperation = null;

    public ResourceOperationHistory getOldestInProgressResourceOperation() {
        if (this.oldestInProgressResourceOperation == null) {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            Resource resource = EnterpriseFacesContextUtility.getResource();
            this.oldestInProgressResourceOperation = this.manager.getOldestInProgressResourceOperation(subject, resource.getId());
        }
        return this.oldestInProgressResourceOperation;
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new A(this, PageControlView.ResourceOperationPendingHistory, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    public String cancel() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedItems = FacesContextUtility.getRequest().getParameterValues("pendingSelectedItems");
        ArrayList<String> success = new ArrayList<String>();
        HashMap<String, String> failure = new HashMap<String, String>();
        String next = null;
        Integer doomed = null;
        for (int i = 0; i < selectedItems.length; ++i) {
            try {
                next = selectedItems[i];
                doomed = Integer.valueOf(next);
                this.manager.cancelOperationHistory(subject, doomed.intValue(), false);
                success.add(next);
                continue;
            }
            catch (Exception e) {
                failure.put(next, ThrowableUtil.getAllMessages((Throwable)e, (boolean)true));
            }
        }
        if (success.size() > 0) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Sent cancel request to the follow in-progress operations: " + StringUtility.getListAsDelimitedString(success)));
        }
        for (Map.Entry error : failure.entrySet()) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to send the cancel request to: " + (String)error.getKey() + ". Cause: " + (String)error.getValue()));
        }
        return "success";
    }
}

