/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.plugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.log.Log;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.admin.plugin.AbstractPluginConfigurationUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Scope(value=ScopeType.PAGE)
@Name(value="editPluginConfigurationUIBean")
public class EditPluginConfigurationUIBean
extends AbstractPluginConfigurationUIBean
implements Serializable {
    @Logger
    private Log log;
    private Configuration currentConfiguration;
    private ConfigurationDefinition currentConfigurationDefinition;

    public Configuration getCurrentConfiguration() {
        return this.currentConfiguration;
    }

    public ConfigurationDefinition getCurrentConfigurationDefinition() {
        return this.currentConfigurationDefinition;
    }

    @Create
    public void init() {
        this.checkPermission();
        this.lookupConfigDefinitions();
    }

    @In(value="plugin", required=false)
    public void setCurrentPlugin(ServerPlugin currentPlugin) {
        if (currentPlugin != null) {
            this.setPlugin(currentPlugin);
        }
    }

    @RequestParameter(value="listName")
    public void setListName(String listName) {
        ServerPlugin plugin = this.getPlugin();
        if (listName != null && plugin != null) {
            if (this.hasListName(plugin.getPluginConfiguration(), listName)) {
                this.currentConfiguration = plugin.getPluginConfiguration();
                this.currentConfigurationDefinition = this.getPluginConfigurationDefinition();
            } else if (this.hasListName(plugin.getScheduledJobsConfiguration(), listName)) {
                this.currentConfiguration = plugin.getScheduledJobsConfiguration();
                this.currentConfigurationDefinition = this.getScheduledJobsDefinition();
            }
        }
    }

    private boolean hasListName(Configuration config, String listName) {
        if (config != null) {
            return config.getList(listName) != null;
        }
        return false;
    }

    public String finishMap() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Map updated.");
        return "success";
    }

    public String updatePlugin() {
        try {
            ServerPluginsLocal serverPlugins = LookupUtil.getServerPlugins();
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            ServerPlugin plugin = serverPlugins.updateServerPluginExceptContent(subject, this.getPlugin());
            this.setPlugin(plugin);
            if (plugin.isEnabled()) {
                serverPlugins.enableServerPlugins(subject, this.getPluginIdList());
            }
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Configuration settings saved.");
        }
        catch (Exception e) {
            this.log.error((Object)"Error updating the plugin configurations.", (Throwable)e, new Object[0]);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"There was an error changing the configuration settings.", (Throwable)e);
            return null;
        }
        return "success";
    }

    private List<Integer> getPluginIdList() {
        ArrayList<Integer> idList = new ArrayList<Integer>(1);
        ServerPlugin plugin = this.getPlugin();
        if (plugin != null) {
            idList.add(plugin.getId());
        }
        return idList;
    }
}

