/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.role;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.gui.admin.role.AddResourceGroupsForm;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.BaseValidatorForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class AddResourceGroupsAction
extends BaseAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog((String)AddResourceGroupsAction.class.getName());
        HttpSession session = request.getSession();
        AddResourceGroupsForm addForm = (AddResourceGroupsForm)form;
        Integer roleId = addForm.getR();
        ActionForward forward = this.checkSubmit(request, mapping, form, "r", (Object)roleId);
        if (forward != null) {
            BaseValidatorForm spiderForm = (BaseValidatorForm)form;
            if (spiderForm.isCancelClicked() || spiderForm.isResetClicked()) {
                log.debug((Object)"removing pending group list");
                SessionUtils.removeList((HttpSession)session, (String)"pendingResGrps");
            } else if (spiderForm.isAddClicked()) {
                log.debug((Object)"adding to pending group list");
                SessionUtils.addToList((HttpSession)session, (String)"pendingResGrps", (Integer[])addForm.getAvailableGroups());
            } else if (spiderForm.isRemoveClicked()) {
                log.debug((Object)"removing from pending group list");
                SessionUtils.removeFromList((HttpSession)session, (String)"pendingResGrps", (Integer[])addForm.getPendingGroups());
            }
            return forward;
        }
        log.debug((Object)"getting pending group list");
        int[] pendingGroupIds = ArrayUtils.unwrapArray((Integer[])SessionUtils.getList((HttpSession)session, (String)"pendingResGrps"));
        for (int i = 0; i < pendingGroupIds.length; ++i) {
            log.debug((Object)("adding group [" + pendingGroupIds[i] + "] for role [" + roleId + "]"));
        }
        RoleManagerLocal roleManager = LookupUtil.getRoleManager();
        roleManager.addResourceGroupsToRole(RequestUtils.getSubject((HttpServletRequest)request), roleId.intValue(), pendingGroupIds);
        log.debug((Object)"removing pending group list");
        SessionUtils.removeList((HttpSession)session, (String)"pendingResGrps");
        RequestUtils.setConfirmation((HttpServletRequest)request, (String)"admin.role.confirm.AddResourceGroups");
        return this.returnSuccess(request, mapping, "r", (Object)roleId);
    }
}

