/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.user;

import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.legacy.Portal;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.action.BaseDispatchAction;
import org.rhq.enterprise.gui.legacy.exception.ParameterNotFoundException;
import org.rhq.enterprise.gui.legacy.util.ActionUtils;
import org.rhq.enterprise.gui.legacy.util.BizappUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.util.LookupUtil;

public class UserAdminPortalAction
extends BaseDispatchAction {
    private static final String TITLE_LIST = "admin.user.ListUsersTitle";
    private static final String PORTLET_LIST = ".admin.user.List";
    private static final String TITLE_ADD_ROLES = "admin.user.AddUserRolesTitle";
    private static final String PORTLET_ADD_ROLES = ".admin.user.UserRoles";
    private static final String TITLE_EDIT = "admin.user.EditUserTitle";
    private static final String PORTLET_EDIT = ".admin.user.Edit";
    private static final String TITLE_NEW = "admin.user.NewUserTitle";
    private static final String PORTLET_NEW = ".admin.user.New";
    private static final String TITLE_VIEW = "admin.user.ViewUserTitle";
    private static final String PORTLET_VIEW = ".admin.user.View";
    private static final String TITLE_CHANGE_PASSWORD = "admin.user.ChangeUserPasswordTitle";
    private static final String PORTLET_CHANGE_PASSWORD = ".admin.user.EditPassword";
    private static final String TITLE_REGISTER = "admin.user.RegisterUserTitle";
    private static final String PORTLET_REGISTER = ".admin.user.RegisterUser";
    protected static Log log = LogFactory.getLog((String)UserAdminPortalAction.class.getName());
    private static Properties keyMethodMap = new Properties();

    protected Properties getKeyMethodMap() {
        return keyMethodMap;
    }

    public ActionForward listUsers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setReturnPath(request, mapping, "list");
        Portal portal = Portal.createPortal((String)TITLE_LIST, (String)PORTLET_LIST);
        portal.setWorkflowPortal(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward addUserRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setUser(request);
        Portal portal = Portal.createPortal((String)TITLE_ADD_ROLES, (String)PORTLET_ADD_ROLES);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward editUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setUser(request);
        Portal portal = Portal.createPortal((String)TITLE_EDIT, (String)PORTLET_EDIT);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward newUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Portal portal = Portal.createPortal((String)TITLE_NEW, (String)PORTLET_NEW);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward viewUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setUser(request);
        this.setReturnPath(request, mapping, "view");
        Portal portal = Portal.createPortal((String)TITLE_VIEW, (String)PORTLET_VIEW);
        portal.setWorkflowPortal(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward changeUserPassword(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setUser(request);
        Portal portal = Portal.createPortal((String)TITLE_CHANGE_PASSWORD, (String)PORTLET_CHANGE_PASSWORD);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward registerUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Portal portal = Portal.createPortal((String)TITLE_REGISTER, (String)PORTLET_REGISTER);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    protected void setUser(HttpServletRequest request) throws Exception {
        Integer userId = RequestUtils.getUserId((HttpServletRequest)request);
        ServletContext ctx = this.getServlet().getServletContext();
        Integer sessionId = RequestUtils.getSessionId((HttpServletRequest)request);
        Subject user = LookupUtil.getSubjectManager().getSubjectById(userId.intValue());
        boolean hasPrincipal = LookupUtil.getSubjectManager().isUserWithPrincipal(user.getName());
        WebUser webUser = new WebUser(user);
        webUser.setHasPrincipal(hasPrincipal);
        request.setAttribute("User", (Object)webUser);
        request.setAttribute("TitleParam", (Object)BizappUtils.makeSubjectFullName((Subject)user));
    }

    protected void setReturnPath(HttpServletRequest request, ActionMapping mapping, String mode) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mode", mode);
        try {
            params.put("u", RequestUtils.getUserId((HttpServletRequest)request));
        }
        catch (ParameterNotFoundException e) {
            // empty catch block
        }
        String returnPath = ActionUtils.findReturnPath((ActionMapping)mapping, params);
        if (log.isTraceEnabled()) {
            log.trace((Object)("setting return path: " + returnPath));
        }
        SessionUtils.setReturnPath((HttpSession)request.getSession(), (String)returnPath);
    }

    static {
        keyMethodMap.setProperty("list", "listUsers");
        keyMethodMap.setProperty("addRoles", "addUserRoles");
        keyMethodMap.setProperty("edit", "editUser");
        keyMethodMap.setProperty("new", "newUser");
        keyMethodMap.setProperty("view", "viewUser");
        keyMethodMap.setProperty("editPass", "changeUserPassword");
        keyMethodMap.setProperty("register", "registerUser");
    }
}

