/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.authentication;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.auth.SessionTimeoutException;

public class SessionAccessServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpServletResponse response = resp;
        HttpServletRequest request = req;
        response.addHeader("Pragma", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Cache-Control", "must-revalidate");
        response.addHeader("Expires", "Mon, 8 Aug 2006 10:00:00 GMT");
        HttpSession session = request.getSession();
        String sessionWebUserUpdate = request.getHeader("rhq_webuser_update");
        String sessionLastAccessUpdate = request.getHeader("rhq_last_access_update");
        if (sessionLastAccessUpdate != null) {
            ServletOutputStream out = response.getOutputStream();
            out.write("success".getBytes());
            return;
        }
        WebUser webUser = SessionUtils.getWebUser((HttpSession)session);
        if (webUser != null && webUser.getSubject() != null) {
            if (sessionWebUserUpdate != null && !sessionWebUserUpdate.trim().isEmpty()) {
                try {
                    Subject currentSubject = SessionManager.getInstance().getSubject(Integer.valueOf(sessionWebUserUpdate).intValue());
                    if (currentSubject != null && webUser.getSubject().getName().equalsIgnoreCase(currentSubject.getName())) {
                        webUser = new WebUser(currentSubject);
                        SessionUtils.setWebUser((HttpSession)session, (WebUser)webUser);
                    }
                }
                catch (SessionNotFoundException snfe) {
                }
                catch (NumberFormatException e) {
                }
                catch (SessionTimeoutException e) {
                    // empty catch block
                }
            }
            Subject subject = webUser.getSubject();
            try {
                SessionManager.getInstance().getSubject(subject.getSessionId().intValue());
                long lastAccess = SessionManager.getInstance().getlastAccess(subject.getSessionId().intValue());
                ServletOutputStream out = response.getOutputStream();
                String output = subject.getId() + ":" + webUser.getSessionId() + ":" + lastAccess;
                out.write(output.getBytes());
            }
            catch (SessionNotFoundException snfe) {
                session.removeAttribute("u");
                SessionUtils.setWebUser((HttpSession)session, null);
                webUser = null;
            }
            catch (SessionTimeoutException ste) {
                session.removeAttribute("u");
                SessionUtils.setWebUser((HttpSession)session, null);
                webUser = null;
            }
        }
    }
}

