/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.configuration.resource;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.EJBException;
import javax.faces.application.FacesMessage;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.rhq.core.domain.configuration.AbstractResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.RawConfiguration;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.configuration.resource.RawConfigDirectory;
import org.rhq.enterprise.gui.configuration.resource.RawConfigUIBean;
import org.rhq.enterprise.gui.configuration.resource.ResourceConfigurationEditor;
import org.rhq.enterprise.gui.configuration.resource.ResourceConfigurationViewer;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Name(value="configurationEditor")
@Scope(value=ScopeType.CONVERSATION)
public class ResourceConfigurationEditor
extends ResourceConfigurationViewer
implements Serializable {
    private Configuration originalResourceConfiguration;
    private Set<String> modifiedFiles = new HashSet();
    private String modalEditorContents;
    @RequestParameter
    private String tab;

    protected void doInitialization() {
        if (this.tab != null) {
            this.setSelectedTab(this.tab);
        }
        this.originalResourceConfiguration = this.resourceConfiguration.deepCopy(true);
    }

    protected void changeToRawTab() {
        this.resourceConfiguration = this.translateToRaw();
        for (RawConfiguration raw : this.resourceConfiguration.getRawConfigurations()) {
            RawConfigUIBean uiBean = this.findRawConfigUIBeanByPath(raw.getPath());
            uiBean.setRawConfiguration(raw);
        }
    }

    private Configuration translateToRaw() {
        ConfigurationManagerLocal configurationMgr = LookupUtil.getConfigurationManager();
        return configurationMgr.translateResourceConfiguration(this.loggedInUser.getSubject(), this.resourceId.intValue(), this.resourceConfiguration, true);
    }

    protected void changeToStructuredTab() {
        this.resourceConfiguration = this.translateToStructured();
        for (RawConfiguration raw : this.resourceConfiguration.getRawConfigurations()) {
            RawConfigUIBean uiBean = this.findRawConfigUIBeanByPath(raw.getPath());
            uiBean.setRawConfiguration(raw);
        }
    }

    private Configuration translateToStructured() {
        ConfigurationManagerLocal configurationMgr = LookupUtil.getConfigurationManager();
        return configurationMgr.translateResourceConfiguration(this.loggedInUser.getSubject(), this.resourceId.intValue(), this.resourceConfiguration, false);
    }

    @Observer(value={"rawConfigUpdate"})
    public void rawConfigUpdated(RawConfigUIBean rawConfigUIBean) {
        if (rawConfigUIBean.isModified()) {
            if (!this.modifiedFiles.contains(rawConfigUIBean.getPath())) {
                this.modifiedFiles.add(rawConfigUIBean.getPath());
            }
        } else if (this.modifiedFiles.contains(rawConfigUIBean.getPath())) {
            this.modifiedFiles.remove(rawConfigUIBean.getPath());
        }
    }

    public boolean isDisplayChangedFilesLabel() {
        if (this.isStructuredMode()) {
            return false;
        }
        if (this.isRawSupported()) {
            return true;
        }
        return this.isRawMode();
    }

    public String getModifiedFilesMsg() {
        if (!this.isDisplayChangedFilesLabel() || this.modifiedFiles.size() == 0) {
            return "";
        }
        if (this.modifiedFiles.size() == 1) {
            return "1 file changed in this configuration";
        }
        return this.modifiedFiles.size() + " files changed in this configuration";
    }

    public boolean getRenderFileUpload() {
        return this.isRawSupported() || this.isStructuredAndRawSupported();
    }

    public String updateConfiguration() {
        ConfigurationManagerLocal configurationMgr = LookupUtil.getConfigurationManager();
        try {
            ResourceConfigurationUpdate updateRequest = this.isStructuredAndRawSupported() ? configurationMgr.updateStructuredOrRawConfiguration(this.loggedInUser.getSubject(), this.resourceId.intValue(), this.resourceConfiguration, this.isStructuredMode()) : configurationMgr.updateResourceConfiguration(this.loggedInUser.getSubject(), this.resourceId.intValue(), this.resourceConfiguration);
            this.clearErrors();
            if (updateRequest != null) {
                switch (1.$SwitchMap$org$rhq$core$domain$configuration$ConfigurationUpdateStatus[updateRequest.getStatus().ordinal()]) {
                    case 1: 
                    case 2: {
                        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Configuration update request with id " + updateRequest.getId() + " has been sent to the Agent."));
                        return "success";
                    }
                    case 3: {
                        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Configuration update request with id " + updateRequest.getId() + " failed."), (String)updateRequest.getErrorMessage());
                        this.copyErrorMessages((AbstractResourceConfigurationUpdate)updateRequest);
                        return "failure";
                    }
                    case 4: {
                        this.addNoChangeMsgToFacesContext();
                        return "nochange";
                    }
                }
            }
        }
        catch (EJBException e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Unable to contact the remote agent.", (Throwable)e.getCause());
            return "failure";
        }
        this.addNoChangeMsgToFacesContext();
        return "nochange";
    }

    private void clearErrors() {
        for (RawConfigDirectory dir : this.rawConfigDirectories) {
            for (RawConfigUIBean bean : dir.getRawConfigUIBeans()) {
                bean.setErrorMessage(null);
            }
        }
    }

    private void copyErrorMessages(AbstractResourceConfigurationUpdate update) {
        Configuration updatedConfiguration = update.getConfiguration();
        for (RawConfiguration updatedRaw : updatedConfiguration.getRawConfigurations()) {
            RawConfigUIBean rawUIBean = this.findRawConfigUIBeanByPath(updatedRaw.getPath());
            if (rawUIBean == null) continue;
            rawUIBean.setErrorMessage(updatedRaw.errorMessage);
        }
    }

    private RawConfiguration findRawConfigurationByPath(String path) {
        for (RawConfiguration raw : this.resourceConfiguration.getRawConfigurations()) {
            if (!raw.getPath().equals(path)) continue;
            return raw;
        }
        return null;
    }

    private void addNoChangeMsgToFacesContext() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"No changes were made to the configuration, so no update request has been sent to the Agent.");
    }

    public void undoEdit(String path) {
        RawConfigUIBean rawConfigUIBean = this.findRawConfigUIBeanByPath(path);
        rawConfigUIBean.undoEdit();
    }

    public String finishAddMap() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Map added.");
        return "success";
    }

    public String finishEditMap() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Map updated.");
        return "success";
    }

    public void setModalEditorContents(String contents) {
        this.modalEditorContents = contents;
    }

    public void applyModalEditContents() {
        this.selectedRawUIBean.setContents(this.modalEditorContents);
    }
}

