/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.model.SelectItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.discovery.InvalidPluginConfigurationClientException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.discovery.MergeResourceResponse;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.inventory.resource.ResourceUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.util.LookupUtil;

public class ManuallyAddChildResourceUIBean {
    public static final String MANAGED_BEAN_NAME = "ManuallyAddChildResourceUIBean";
    private static final String OUTCOME_BAD_TYPE = "badType";
    private static final String OUTCOME_SUCCESS = "success";
    private static final String OUTCOME_FAILURE = "failure";
    private static final String OUTCOME_MULTIPLE_TEMPLATES = "multipleTemplates";
    private static final String OUTCOME_SINGLE_TEMPLATE = "singleTemplate";
    private ResourceType type;
    private String name;
    private String description;
    private ConfigurationDefinition configurationDefinition;
    private Configuration configuration;
    private String selectedTemplateName;
    private ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
    private ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
    private DiscoveryBossLocal discoveryBoss = LookupUtil.getDiscoveryBoss();

    public ManuallyAddChildResourceUIBean() {
        this.type = this.lookupResourceType();
        if (!this.type.isSupportsManualAdd()) {
            throw new IllegalStateException(this.type.getName() + " resources cannot be manually added to inventory.");
        }
        this.lookupConfigurationAndDef();
    }

    private void lookupConfigurationAndDef() {
        this.configurationDefinition = this.lookupConfigurationDefinition();
        if (this.configurationDefinition != null) {
            this.configuration = this.lookupConfiguration();
            ConfigurationTemplate defaultTemplate = this.configurationDefinition.getDefaultTemplate();
            this.selectedTemplateName = defaultTemplate != null ? defaultTemplate.getName() : null;
        }
    }

    @Nullable
    public ConfigurationDefinition getConfigurationDefinition() {
        return this.configurationDefinition;
    }

    public void setConfigurationDefinition(@NotNull ConfigurationDefinition configurationDefinition) {
        this.configurationDefinition = configurationDefinition;
    }

    @Nullable
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(@NotNull Configuration configuration) {
        this.configuration = configuration;
    }

    public List<SelectItem> getTemplateNames() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (ConfigurationTemplate template : this.configurationDefinition.getTemplates().values()) {
            StringBuilder label = new StringBuilder(template.getName());
            if (template.getDescription() != null && !template.getDescription().equals("") && !template.getDescription().equals(template.getName())) {
                label.append(" - ").append(template.getDescription());
            }
            SelectItem selectItem = new SelectItem((Object)template.getName(), label.toString());
            selectItems.add(selectItem);
        }
        return selectItems;
    }

    public String startWorkflow() {
        try {
            this.type = this.lookupResourceType();
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Could not retrieve resource type.", (String)e.getLocalizedMessage());
            return OUTCOME_BAD_TYPE;
        }
        if (this.configurationDefinition == null) {
            this.lookupConfigurationAndDef();
        }
        if (this.configurationDefinition == null) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("There are no connection properties defined for " + this.type));
            return OUTCOME_BAD_TYPE;
        }
        return this.configurationDefinition.getTemplates().size() > 1 ? OUTCOME_MULTIPLE_TEMPLATES : OUTCOME_SINGLE_TEMPLATE;
    }

    public String selectTemplate() {
        this.lookupConfiguration();
        return OUTCOME_SUCCESS;
    }

    public String addResource() {
        String outcome;
        MergeResourceResponse mergeResourceResponse = null;
        try {
            mergeResourceResponse = this.discoveryBoss.manuallyAddResource(EnterpriseFacesContextUtility.getSubject(), this.getType(), EnterpriseFacesContextUtility.getResource().getId(), this.getConfiguration());
        }
        catch (InvalidPluginConfigurationClientException e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("The Agent was unable to connect to the " + this.getType() + " managed resource using the supplied connection properties. Please check that the connection properties are correct and that the managed resource on the agent machine is online. "), (Throwable)e);
        }
        catch (PluginContainerException e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_FATAL, (String)"An unexpected error occurred in the Agent.", (Throwable)e);
        }
        catch (RuntimeException e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_FATAL, (String)"Unable to connect to the Agent.", (Throwable)e);
        }
        if (mergeResourceResponse == null) {
            outcome = OUTCOME_FAILURE;
        } else {
            Resource resource = LookupUtil.getResourceManager().getResourceById(EnterpriseFacesContextUtility.getSubject(), mergeResourceResponse.getResourceId());
            if (mergeResourceResponse.resourceAlreadyExisted()) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)("A " + this.getType().getName() + " with the specified connection properties was already in inventory."));
            } else {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("A " + this.getType().getName() + " has been added to inventory with the name '" + resource.getName() + "'."));
            }
            FacesContextUtility.setBean((Object)new ResourceUIBean(resource));
            outcome = OUTCOME_SUCCESS;
        }
        this.cleanup();
        return outcome;
    }

    public String cancel() {
        this.cleanup();
        return OUTCOME_SUCCESS;
    }

    @Nullable
    protected ConfigurationDefinition lookupConfigurationDefinition() {
        Integer resourceTypeId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"type", Integer.class);
        ConfigurationDefinition pluginConfigDefinition = this.configurationManager.getPluginConfigurationDefinitionForResourceType(EnterpriseFacesContextUtility.getSubject(), resourceTypeId.intValue());
        return pluginConfigDefinition;
    }

    @NotNull
    protected Configuration lookupConfiguration() {
        ConfigurationTemplate pluginConfigTemplate;
        if (this.selectedTemplateName != null) {
            pluginConfigTemplate = this.getConfigurationDefinition().getTemplate(this.selectedTemplateName);
            if (pluginConfigTemplate == null) {
                throw new IllegalStateException("A template named '" + this.selectedTemplateName + "' does not exist for " + this.getType() + " resource connection properties.");
            }
        } else {
            pluginConfigTemplate = this.getConfigurationDefinition().getDefaultTemplate();
        }
        this.configuration = pluginConfigTemplate != null ? pluginConfigTemplate.createConfiguration() : new Configuration();
        return this.configuration;
    }

    public ResourceType getType() {
        return this.type;
    }

    private ResourceType lookupResourceType() {
        Integer resourceTypeId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"type", Integer.class);
        try {
            return this.resourceTypeManager.getResourceTypeById(EnterpriseFacesContextUtility.getSubject(), resourceTypeId.intValue());
        }
        catch (ResourceTypeNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private void cleanup() {
        this.configuration = null;
        this.configurationDefinition = null;
        this.type = null;
        this.selectedTemplateName = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNullConfigurationDefinitionMessage() {
        return "Could not find this resource's plugin configuration definition.";
    }

    public String getNullConfigurationMessage() {
        return "This resource's default plugin configuration is null - this should never happen.";
    }

    public String getSelectedTemplateName() {
        return this.selectedTemplateName;
    }

    public void setSelectedTemplateName(String selectedTemplateName) {
        this.selectedTemplateName = selectedTemplateName;
    }
}

