/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.gui.common.tag.FunctionTagLibrary;
import org.rhq.enterprise.gui.inventory.resource.ResourceLineageComponent;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.HibernatePerformanceMonitor;
import org.rhq.enterprise.server.util.LookupUtil;

public class ResourceLineageRenderer
extends Renderer {
    private static final String SEPARATOR = " > ";
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResourceLineageComponent resourceLineage = (ResourceLineageComponent)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        long monitorId = HibernatePerformanceMonitor.get().start();
        List ancestorResources = this.resourceManager.getResourceLineage(resourceLineage.getResourceId());
        HibernatePerformanceMonitor.get().stop(monitorId, "ResourceLineage renderer");
        if (ancestorResources.isEmpty()) {
            throw new IllegalStateException("The list of ancestor resources should always contain at least one resource - the resource whose lineage was requested.");
        }
        Resource parentResource = (Resource)ancestorResources.get(ancestorResources.size() - 1);
        for (Resource ancestorResource : ancestorResources) {
            writer.startElement("a", (UIComponent)resourceLineage);
            writer.writeAttribute("href", (Object)this.buildURL(ancestorResource), null);
            writer.writeText((Object)ancestorResource.getName(), null);
            writer.endElement("a");
            if (ancestorResource.getId() == parentResource.getId()) continue;
            writer.writeText((Object)SEPARATOR, null);
        }
    }

    private String buildURL(Resource resource) {
        String url = FunctionTagLibrary.getDefaultResourceTabURL() + "?id=" + resource.getId();
        url = FacesContext.getCurrentInstance().getExternalContext().encodeResourceURL(url);
        return url;
    }
}

