/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.ui.MetricDisplaySummary;
import org.rhq.core.domain.measurement.ui.MetricDisplayValue;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.action.WorkflowPrepareAction;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.CompareMetricsForm;
import org.rhq.enterprise.gui.legacy.util.MonitorUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.measurement.MeasurementChartsManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.util.LookupUtil;

public class CompareMetricsFormPrepareAction
extends WorkflowPrepareAction {
    protected static Log log = LogFactory.getLog(CompareMetricsFormPrepareAction.class);

    public ActionForward workflow(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CompareMetricsForm cform = (CompareMetricsForm)form;
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
        if (cform.childResourceIds != null && cform.childResourceIds.length > 0) {
            int[] definitionIds = LookupUtil.getResourceGroupManager().findDefinitionsForCompatibleGroup(user.getSubject(), cform.getGroupId(), false);
            Locale userLocale = request.getLocale();
            cform.setMetrics(this.getMetrics(user.getSubject(), ArrayUtils.unwrapArray((Integer[])cform.childResourceIds), definitionIds, rangePreferences.begin.longValue(), rangePreferences.end.longValue(), userLocale));
            cform.setRb(rangePreferences.begin);
            cform.setRe(rangePreferences.end);
        }
        return null;
    }

    private Map<MeasurementCategory, Map<MeasurementDefinition, List<MetricDisplaySummary>>> getMetrics(Subject subject, int[] resourceIds, int[] definitionIds, long begin, long end, Locale locale) {
        MeasurementChartsManagerLocal chartsManager = LookupUtil.getMeasurementChartsManager();
        Map data = chartsManager.getMetricDisplaySummariesForMetricsCompare(subject, resourceIds, definitionIds, begin, end);
        HashMap<MeasurementCategory, Map<MeasurementDefinition, List<MetricDisplaySummary>>> compareMetrics = new HashMap<MeasurementCategory, Map<MeasurementDefinition, List<MetricDisplaySummary>>>();
        for (MeasurementDefinition definition : data.keySet()) {
            MeasurementCategory category = definition.getCategory();
            HashMap<MeasurementDefinition, List> listWithinCategory = (HashMap<MeasurementDefinition, List>)compareMetrics.get(category);
            if (listWithinCategory == null) {
                listWithinCategory = new HashMap<MeasurementDefinition, List>();
                compareMetrics.put(category, listWithinCategory);
            }
            List listOfData = (List)data.get(definition);
            for (MetricDisplaySummary summary : listOfData) {
                MonitorUtils.formatSimpleMetrics((MetricDisplaySummary)summary, (Locale)locale);
                this.setSummaryHasValues(summary);
            }
            listWithinCategory.put(definition, listOfData);
        }
        return compareMetrics;
    }

    private void setSummaryHasValues(MetricDisplaySummary summary) {
        Map metrics = summary.getMetrics();
        for (MetricDisplayValue metricDisplayValue : metrics.values()) {
            Double value = metricDisplayValue.getValue();
            if (value == null || value.isNaN()) continue;
            summary.setValuesPresent(true);
        }
    }
}

