/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.role;

import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.authz.Role;
import org.rhq.enterprise.gui.admin.role.RoleForm;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class EditAction
extends BaseAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog((String)EditAction.class.getName());
        RoleForm editForm = (RoleForm)form;
        Integer roleId = editForm.getR();
        ActionForward forward = this.checkSubmit(request, mapping, form, "r", (Object)roleId);
        if (forward != null) {
            return forward;
        }
        log.trace((Object)("getting role [" + roleId + "]"));
        RoleManagerLocal roleManager = LookupUtil.getRoleManager();
        Role role = roleManager.getRoleById(roleId);
        role.setName(editForm.getName());
        role.setDescription(editForm.getDescription());
        role.setPermissions(new HashSet(editForm.getPermissions()));
        log.trace((Object)("saving role [" + roleId + "]"));
        try {
            roleManager.updateRole(RequestUtils.getSubject((HttpServletRequest)request), role);
        }
        catch (Exception ex) {
            log.debug((Object)"role update failed:", (Throwable)ex);
            RequestUtils.setError((HttpServletRequest)request, (String)"admin.role.error.BadRole");
            return this.returnFailure(request, mapping);
        }
        RequestUtils.setConfirmation((HttpServletRequest)request, (String)"admin.role.confirm.Edit");
        return this.returnSuccess(request, mapping, "r", (Object)roleId);
    }
}

