/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.scheduling;

import java.util.Date;
import org.quartz.SimpleTrigger;
import org.rhq.enterprise.gui.common.scheduling.supporting.TimeUnits;

public class OperationDetailsScheduleComponent {
    private String start = "immediate";
    private Date startDate;
    private Date endDate;
    private String recur = "never";
    private int repeatInterval = 1;
    private TimeUnits unit;
    private String end = "none";
    private boolean readOnly;
    private boolean deferred;
    private boolean repeat;
    private boolean terminate;

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getRecur() {
        return this.recur;
    }

    public void setRecur(String recur) {
        this.recur = recur;
    }

    public int getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(int repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public TimeUnits getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnits unit) {
        this.unit = unit;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public void setDeferred(boolean deferred) {
        this.deferred = deferred;
    }

    public boolean getDeferred() {
        this.deferred = this.start.equals("startDate");
        return this.deferred;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public boolean getRepeat() {
        this.repeat = this.recur.equals("recur");
        return this.repeat;
    }

    public void setTerminate(boolean terminate) {
        this.terminate = terminate;
    }

    public boolean getTerminate() {
        this.terminate = this.end.equals("endDate");
        return this.terminate;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public OperationDetailsScheduleComponent(SimpleTrigger trigger) {
        Date endDateTime;
        long repeatMillis;
        this.setDeferred(true);
        this.setStartDate(trigger.getStartTime());
        this.setStart("startDate");
        int repeatCount = trigger.getRepeatCount();
        if (repeatCount != 0) {
            this.setRepeat(true);
            if (repeatCount == -1) {
                this.setRecur("never");
                this.setRepeatInterval(1);
            } else {
                this.setRecur("recur");
                this.setRepeatInterval(repeatCount);
            }
        }
        if ((repeatMillis = trigger.getRepeatInterval()) != 0L) {
            this.setRecur("recur");
            this.setRepeat(true);
            long repeatSecs = repeatMillis / 1000L;
            this.setRepeatInterval((int)repeatSecs);
            this.setUnit(TimeUnits.Seconds);
        }
        if ((endDateTime = trigger.getEndTime()) != null) {
            this.setTerminate(true);
            this.setEndDate(endDateTime);
            this.setEnd("endDate");
        } else {
            this.setEnd("none");
        }
    }

    public OperationDetailsScheduleComponent() {
    }
}

