/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.AvailableResourceReposUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class AvailableResourceReposUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "AvailableResourceReposUIBean";

    public String subscribeSelectedResourceRepos() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedResourceRepos();
        int resourceId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        int[] repoIds = this.getIntegerArray(selected);
        if (repoIds != null && repoIds.length > 0) {
            try {
                RepoManagerLocal manager = LookupUtil.getRepoManagerLocal();
                manager.subscribeResourceToRepos(subject, resourceId, repoIds);
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Subscribed [" + repoIds.length + "] repositories to resource"));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to subscribe one or more repositories to resource", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ResourceReposDataModel(this, PageControlView.AvailableResourceReposList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedResourceRepos() {
        return FacesContextUtility.getRequest().getParameterValues("selectedAvailableResourceRepos");
    }

    private int[] getIntegerArray(String[] input) {
        if (input == null) {
            return new int[0];
        }
        int[] output = new int[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

