/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.gui.common.converter.SelectItemUtils;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ListPackagesUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListPackagesUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ListPackagesUIBean";
    private Resource resource;
    private Integer selectedPackage;
    private SelectItem[] packageTypes;
    private String packageTypeFilter;
    private SelectItem[] packageVersions;
    private String packageVersionFilter;
    private String search;
    private ContentManagerLocal contentManager = LookupUtil.getContentManager();
    private ContentUIManagerLocal contentUIManager = LookupUtil.getContentUIManager();

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListInstalledPackagesDataModel(this, PageControlView.InstalledPackagesList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    public Integer getSelectedPackage() {
        return this.selectedPackage;
    }

    public void setSelectedPackage(Integer selectedPackage) {
        this.selectedPackage = selectedPackage;
    }

    public String getContentBackedResourceTypeName() {
        this.resource = EnterpriseFacesContextUtility.getResource();
        ResourceType resourceType = this.resource.getResourceType();
        if (resourceType.getCreationDataType() != ResourceCreationDataType.CONTENT) {
            return null;
        }
        ContentUIManagerLocal contentUIManager = LookupUtil.getContentUIManager();
        List packageTypes = contentUIManager.getPackageTypes(resourceType.getId());
        for (PackageType type : packageTypes) {
            if (!type.isCreationData()) continue;
            return type.getName();
        }
        return null;
    }

    public SelectItem[] getPackageTypes() {
        if (this.packageTypes == null) {
            List items = this.contentUIManager.getInstalledPackageTypes(EnterpriseFacesContextUtility.getSubject(), EnterpriseFacesContextUtility.getResource().getId());
            this.packageTypes = SelectItemUtils.convertFromListOptionItem((List)items, (boolean)true);
        }
        return this.packageTypes;
    }

    public void setPackageTypes(SelectItem[] packageTypes) {
        this.packageTypes = packageTypes;
    }

    public String getPackageTypeFilter() {
        if (this.packageTypeFilter == null) {
            this.packageTypeFilter = SelectItemUtils.getSelectItemFilter((String)"contentForm:packageTypeFilter");
        }
        return SelectItemUtils.cleanse((String)this.packageTypeFilter);
    }

    public Integer getPackageTypeFilterAsInteger() {
        String packageTypeFilterString = this.getPackageTypeFilter();
        if (packageTypeFilterString != null) {
            return Integer.parseInt(packageTypeFilterString);
        }
        return null;
    }

    public void setPackageTypeFilter(String packageTypeFilter) {
        this.packageTypeFilter = packageTypeFilter;
    }

    public SelectItem[] getPackageVersions() {
        if (this.packageVersions == null) {
            List items = this.contentManager.findInstalledPackageVersions(EnterpriseFacesContextUtility.getSubject(), EnterpriseFacesContextUtility.getResource().getId());
            this.packageVersions = SelectItemUtils.convertFromListString((List)items, (boolean)true);
        }
        return this.packageVersions;
    }

    public void setPackageVersions(SelectItem[] packageVersions) {
        this.packageVersions = packageVersions;
    }

    public String getPackageVersionFilter() {
        if (this.packageVersionFilter == null) {
            this.packageVersionFilter = SelectItemUtils.getSelectItemFilter((String)"contentForm:packageVersionFilter");
        }
        return SelectItemUtils.cleanse((String)this.packageVersionFilter);
    }

    public void setPackageVersionFilter(String packageVersionFilter) {
        this.packageVersionFilter = packageVersionFilter;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    static /* synthetic */ Resource access$000(ListPackagesUIBean x0) {
        return x0.resource;
    }

    static /* synthetic */ Resource access$002(ListPackagesUIBean x0, Resource x1) {
        x0.resource = x1;
        return x0.resource;
    }

    static /* synthetic */ String access$100(ListPackagesUIBean x0) {
        return x0.search;
    }

    static /* synthetic */ ContentUIManagerLocal access$200(ListPackagesUIBean x0) {
        return x0.contentUIManager;
    }
}

