/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.NumberFormat;
import org.rhq.enterprise.gui.image.ImageUtil;
import org.rhq.enterprise.gui.image.WebImage;

public class AvailabilityReport
extends WebImage {
    private static int CIRCLE_SIZE = 11;
    private static BufferedImage GOOD_CIRCLE;
    private static BufferedImage DANGER_CIRCLE;
    private static BufferedImage UNKNOWN_CIRCLE;
    private static final Font FONT;
    private static final Color COLOR_TRANSPARENT;
    private static final String LARGEST_NUMBER = "999";
    private static final int TEXT_BUFFER = 2;
    private static final int SET_BUFFER = 5;
    private static final int CIRCLE_WITH_BUFFER_WIDTH;
    private static final int STANDARD_SET_WIDTH;
    private static final int IMAGE_WIDTH;
    public int Available;
    public int Unavailable;
    public int Unknown;

    public AvailabilityReport() {
        super(IMAGE_WIDTH, GOOD_CIRCLE.getHeight());
        this.antiAliased = false;
        this.indexColors = true;
    }

    protected void draw(Graphics2D g) {
        String text;
        boolean x = false;
        int yCircle = 0;
        int y2Circle = CIRCLE_SIZE - 1;
        g.setPaint(COLOR_TRANSPARENT);
        g.fillRect(0, 0, this.width, this.height);
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumFractionDigits(0);
        g.setColor(this.textColor);
        g.setFont(FONT);
        if (this.Available > 0) {
            text = fmt.format(this.Available);
            g.drawImage(GOOD_CIRCLE, 0, yCircle, COLOR_TRANSPARENT, null);
            g.drawString(text, CIRCLE_WITH_BUFFER_WIDTH, y2Circle);
        }
        if (this.Unavailable > 0) {
            text = fmt.format(this.Unavailable);
            g.drawImage(DANGER_CIRCLE, STANDARD_SET_WIDTH, yCircle, COLOR_TRANSPARENT, null);
            g.drawString(text, STANDARD_SET_WIDTH + CIRCLE_WITH_BUFFER_WIDTH, y2Circle);
        }
        if (this.Unknown > 0) {
            text = fmt.format(this.Unknown);
            g.drawImage(UNKNOWN_CIRCLE, STANDARD_SET_WIDTH * 2, yCircle, COLOR_TRANSPARENT, null);
            g.drawString(text, STANDARD_SET_WIDTH * 2 + CIRCLE_WITH_BUFFER_WIDTH, y2Circle);
        }
    }

    static {
        FONT = new Font("sansserif.plain", 0, 10);
        COLOR_TRANSPARENT = new Color(3, 3, 3);
        try {
            GOOD_CIRCLE = ImageUtil.loadImage((String)"images/icon_available_green.gif");
            DANGER_CIRCLE = ImageUtil.loadImage((String)"images/icon_available_red.gif");
            UNKNOWN_CIRCLE = ImageUtil.loadImage((String)"images/icon_available_error.gif");
        }
        catch (IOException e) {
            System.out.println(e);
        }
        CIRCLE_WITH_BUFFER_WIDTH = GOOD_CIRCLE.getWidth() + 2;
        STANDARD_SET_WIDTH = CIRCLE_WITH_BUFFER_WIDTH + DEFAULT_FONT_METRICS.stringWidth(LARGEST_NUMBER) + 5;
        IMAGE_WIDTH = STANDARD_SET_WIDTH * 3 - 5;
    }
}

