/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.rhq.core.clientapi.util.StringUtil;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.composite.ResourceIdFlyWeight;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.action.resource.hub.HubView;
import org.rhq.enterprise.server.alert.engine.internal.Tuple;
import org.rhq.enterprise.server.auth.prefs.SubjectPreferencesBase;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebUserPreferences
extends SubjectPreferencesBase {
    public static final String PREF_DASH_SHOW_SUMMARY_COUNTS_PLATFORM = ".dashContent.summaryCounts.platform";
    public static final String PREF_DASH_SHOW_SUMMARY_COUNTS_SERVER = ".dashContent.summaryCounts.server";
    public static final String PREF_DASH_SHOW_SUMMARY_COUNTS_SERVICE = ".dashContent.summaryCounts.service";
    public static final String PREF_DASH_SHOW_SUMMARY_COUNTS_GROUP_COMPAT = ".dashContent.summaryCounts.group.compat";
    public static final String PREF_DASH_SHOW_SUMMARY_COUNTS_GROUP_MIXED = ".dashContent.summaryCounts.group.mixed";
    public static final String PREF_DASH_SHOW_SUMMARY_COUNTS_GROUP_DEFINITIONS = ".dashContent.summaryCounts.group.definition";
    public static final String PREF_DASH_AUTODISCOVERY_RANGE = ".dashContent.autoDiscovery.range";
    public static final String PREF_DASH_OPERATION_LAST_COMPLETED = ".dashContent.operations.lastCompleted";
    public static final String PREF_DASH_OPERATION_NEXT_SCHEDULED = ".dashContent.operations.nextScheduled";
    public static final String PREF_DASH_OPERATION_USE_LAST_COMPLETED = ".dashContent.operations.useLastCompleted";
    public static final String PREF_DASH_OPERATION_USE_NEXT_SCHEDULED = ".dashContent.operations.useNextScheduled";
    public static final String PREF_DASH_ALERTS_COUNT = ".dashContent.criticalalerts.numberOfAlerts";
    public static final String PREF_DASH_ALERTS_PRIORITY = ".dashContent.criticalalerts.priority";
    public static final String PREF_DASH_ALERTS_PAST = ".dashContent.criticalalerts.past";
    public static final String PREF_DASH_ALERTS_SELECTED_OR_ALL = ".dashContent.criticalalerts.selectedOrAll";
    public static final String PREF_DASH_ALERTS_RESOURCES = ".dashContent.criticalalerts.resources";
    public static final String PREF_DASH_PROBLEM_RESOURCES_ROWS = ".dashContent.problemResources.range";
    public static final String PREF_DASH_PROBLEM_RESOURCES_HOURS = ".dashContent.problemResources.hours";
    public static final String PREF_DASH_PROBLEM_RESOURCES_SHOW_IGNORED = ".dashContent.problemResources.showIgnored";
    public static final String PREF_DASH_PROBLEM_RESOURCES_IGNORED = ".dashContent.problemResources.ignoreList";
    public static final String PREF_DASH_RECENTLY_APPROVED_RANGE = ".dashContent.recentlyApproved.range";
    public static final String PREF_DASH_RECENTLY_APPROVED_HOURS = ".dashContent.recentlyApproved.hours";
    public static final String PREF_DASH_RECENTLY_APPROVED_EXPANDED_PLATFORMS = ".dashContent.recentlyApproved.expandedPlatforms";
    public static final String PREF_DASH_FAVORITE_RESOURCES_AVAILABILITY = ".dashContent.resourcehealth.availability";
    public static final String PREF_DASH_FAVORITE_RESOURCES_ALERTS = ".dashContent.resourcehealth.alerts";
    public static final String PREF_DASH_FAVORITE_RESOURCES = ".dashContent.resourcehealth.resources";
    public static final String PREF_DASH_FAVORITE_GROUPS = ".dashContent.grouphealth.groups";
    public static final String PREF_DASH_USER_SAVED_CHARTS = ".dashContent.charts";
    public static final String PREF_DASH_PORTLETS_FIRST = ".dashcontent.portal.portlets.first";
    public static final String PREF_DASH_PORTLETS_SECOND = ".dashcontent.portal.portlets.second";
    public static final String PREF_RESOURCE_BROWSER_VIEW_MODE = ".resource.browser.view";
    public static final String PREF_PAGE_REFRESH_PERIOD = ".page.refresh.period";
    public static final String PREF_LAST_URL = ".last.url";
    public static final String PREF_RECENT_RESOURCES = ".recent.resources";

    public WebUserPreferences(Subject subject) {
        super(subject);
    }

    public int getPageRefreshPeriod() {
        return this.getIntPref(".page.refresh.period", 0);
    }

    public void setPageRefreshPeriod(int period) {
        this.setPreference(".page.refresh.period", (Object)period);
    }

    public String getLastVisitedURL(int previousOffset) {
        List urls = this.getPreferenceAsList(".last.url");
        String url = (String)urls.get(urls.size() - previousOffset);
        return url;
    }

    public void addLastVisitedURL(String url) {
        ArrayList<String> urls = this.getPreferenceAsList(".last.url");
        if (urls == null) {
            urls = new ArrayList<String>();
        }
        urls.add(url);
        if (urls.size() > 3) {
            urls.remove(0);
        }
        this.setPreference(".last.url", urls);
    }

    public SummaryCountPortletPreferences getSummaryCounts() {
        SummaryCountPortletPreferences counts = new SummaryCountPortletPreferences();
        counts.showPlatforms = this.getBooleanPref(".dashContent.summaryCounts.platform", true);
        counts.showServers = this.getBooleanPref(".dashContent.summaryCounts.server", true);
        counts.showServices = this.getBooleanPref(".dashContent.summaryCounts.service", true);
        counts.showCompatibleGroups = this.getBooleanPref(".dashContent.summaryCounts.group.compat", true);
        counts.showMixedGroups = this.getBooleanPref(".dashContent.summaryCounts.group.mixed", true);
        counts.showGroupDefinitions = this.getBooleanPref(".dashContent.summaryCounts.group.definition", true);
        return counts;
    }

    public void setSummaryCounts(SummaryCountPortletPreferences counts) {
        this.setPreference(".dashContent.summaryCounts.platform", (Object)counts.showPlatforms);
        this.setPreference(".dashContent.summaryCounts.server", (Object)counts.showServers);
        this.setPreference(".dashContent.summaryCounts.service", (Object)counts.showServices);
        this.setPreference(".dashContent.summaryCounts.group.compat", (Object)counts.showCompatibleGroups);
        this.setPreference(".dashContent.summaryCounts.group.mixed", (Object)counts.showMixedGroups);
        this.setPreference(".dashContent.summaryCounts.group.definition", (Object)counts.showGroupDefinitions);
    }

    public int getAutoDiscoveryRange() {
        return this.getIntPref(".dashContent.autoDiscovery.range");
    }

    public void setAutoDiscoveryRange(int range) {
        this.setPreference(".dashContent.autoDiscovery.range", (Object)range);
    }

    public OperationPortletPreferences getOperationPortletPreferences() {
        OperationPortletPreferences prefs = new OperationPortletPreferences();
        prefs.lastCompleted = this.getIntPref(".dashContent.operations.lastCompleted");
        prefs.nextScheduled = this.getIntPref(".dashContent.operations.nextScheduled");
        prefs.useLastCompleted = this.getBooleanPref(".dashContent.operations.useLastCompleted");
        prefs.useNextScheduled = this.getBooleanPref(".dashContent.operations.useNextScheduled");
        return prefs;
    }

    public void setOperationPortletPreferences(OperationPortletPreferences prefs) {
        this.setPreference(".dashContent.operations.lastCompleted", (Object)prefs.lastCompleted);
        this.setPreference(".dashContent.operations.nextScheduled", (Object)prefs.nextScheduled);
        this.setPreference(".dashContent.operations.useLastCompleted", (Object)prefs.useLastCompleted);
        this.setPreference(".dashContent.operations.useNextScheduled", (Object)prefs.useNextScheduled);
    }

    public AlertsPortletPreferences getAlertsPortletPreferences() {
        AlertsPortletPreferences prefs = new AlertsPortletPreferences();
        prefs.count = this.getIntPref(".dashContent.criticalalerts.numberOfAlerts");
        prefs.priority = this.getIntPref(".dashContent.criticalalerts.priority");
        prefs.timeRange = this.getLongPref(".dashContent.criticalalerts.past");
        prefs.displayAll = this.getPreference(".dashContent.criticalalerts.selectedOrAll");
        AlertsPortletPreferences.access$002((AlertsPortletPreferences)prefs, (List)this.getPreferenceAsIntegerList(".dashContent.criticalalerts.resources", "|"));
        if (this.removeDeletedResources(AlertsPortletPreferences.access$000((AlertsPortletPreferences)prefs))) {
            this.setAlertsPortletPreferences(prefs);
        }
        return prefs;
    }

    public void setAlertsPortletPreferences(AlertsPortletPreferences prefs) {
        this.setPreference(".dashContent.criticalalerts.numberOfAlerts", (Object)prefs.count);
        this.setPreference(".dashContent.criticalalerts.priority", (Object)prefs.priority);
        this.setPreference(".dashContent.criticalalerts.past", (Object)prefs.timeRange);
        this.setPreference(".dashContent.criticalalerts.selectedOrAll", (Object)prefs.displayAll);
        this.setPreference(".dashContent.criticalalerts.resources", AlertsPortletPreferences.access$000((AlertsPortletPreferences)prefs), "|");
    }

    public ProblemResourcesPortletPreferences getProblemResourcesPortletPreferences() {
        ProblemResourcesPortletPreferences prefs = new ProblemResourcesPortletPreferences();
        prefs.range = this.getIntPref(".dashContent.problemResources.range", 10);
        prefs.hours = this.getIntPref(".dashContent.problemResources.hours", -1);
        prefs.showIgnored = this.getBooleanPref(".dashContent.problemResources.showIgnored");
        prefs.ignoreList = this.getPreference(".dashContent.problemResources.ignoreList");
        return prefs;
    }

    public void setProblemResourcesPortletPreferences(ProblemResourcesPortletPreferences prefs) {
        this.setPreference(".dashContent.problemResources.range", (Object)prefs.range);
        this.setPreference(".dashContent.problemResources.hours", (Object)prefs.hours);
        this.setPreference(".dashContent.problemResources.showIgnored", (Object)prefs.showIgnored);
        this.setPreference(".dashContent.problemResources.ignoreList", (Object)prefs.ignoreList);
    }

    public RecentlyApprovedPortletPreferences getRecentlyApprovedPortletPreferences() {
        RecentlyApprovedPortletPreferences prefs = new RecentlyApprovedPortletPreferences();
        prefs.range = this.getIntPref(".dashContent.recentlyApproved.range", 10);
        prefs.hours = this.getIntPref(".dashContent.recentlyApproved.hours", -1);
        prefs.expandedPlatforms = this.getPreferenceAsList(".dashContent.recentlyApproved.expandedPlatforms");
        return prefs;
    }

    public void setRecentlyApprovedPortletPreferences(RecentlyApprovedPortletPreferences prefs) {
        this.setPreference(".dashContent.recentlyApproved.range", (Object)prefs.range);
        this.setPreference(".dashContent.recentlyApproved.hours", (Object)prefs.hours);
        this.setPreference(".dashContent.recentlyApproved.expandedPlatforms", prefs.expandedPlatforms);
    }

    public DateTimeDisplayPreferences getDateTimeDisplayPreferences() {
        return new DateTimeDisplayPreferences();
    }

    public FavoriteResourcePortletPreferences getFavoriteResourcePortletPreferences() {
        FavoriteResourcePortletPreferences prefs = new FavoriteResourcePortletPreferences();
        prefs.showAvailability = this.getBooleanPref(".dashContent.resourcehealth.availability");
        prefs.showAlerts = this.getBooleanPref(".dashContent.resourcehealth.alerts");
        FavoriteResourcePortletPreferences.access$102((FavoriteResourcePortletPreferences)prefs, (List)this.getPreferenceAsIntegerList(".dashContent.resourcehealth.resources", "|"));
        if (this.removeDeletedResources(FavoriteResourcePortletPreferences.access$100((FavoriteResourcePortletPreferences)prefs))) {
            this.setFavoriteResourcePortletPreferences(prefs);
        }
        return prefs;
    }

    public void setFavoriteResourcePortletPreferences(FavoriteResourcePortletPreferences prefs) {
        this.setPreference(".dashContent.resourcehealth.availability", (Object)prefs.showAvailability);
        this.setPreference(".dashContent.resourcehealth.alerts", (Object)prefs.showAlerts);
        this.setPreference(".dashContent.resourcehealth.resources", FavoriteResourcePortletPreferences.access$100((FavoriteResourcePortletPreferences)prefs), "|");
    }

    public FavoriteGroupPortletPreferences getFavoriteGroupPortletPreferences() {
        FavoriteGroupPortletPreferences prefs = new FavoriteGroupPortletPreferences();
        FavoriteGroupPortletPreferences.access$202((FavoriteGroupPortletPreferences)prefs, (List)this.getPreferenceAsIntegerList(".dashContent.grouphealth.groups", "|"));
        if (this.removeDeletedGroups(FavoriteGroupPortletPreferences.access$200((FavoriteGroupPortletPreferences)prefs))) {
            this.setFavoriteGroupPortletPreferences(prefs);
        }
        return prefs;
    }

    public void setFavoriteGroupPortletPreferences(FavoriteGroupPortletPreferences prefs) {
        this.setPreference(".dashContent.grouphealth.groups", FavoriteGroupPortletPreferences.access$200((FavoriteGroupPortletPreferences)prefs), "|");
    }

    public DashboardPreferences getDashboardPreferences() {
        DashboardPreferences prefs = new DashboardPreferences();
        prefs.leftColumnPortletNames = this.getPreference(".dashcontent.portal.portlets.first");
        prefs.rightColumnPortletNames = this.getPreference(".dashcontent.portal.portlets.second");
        return prefs;
    }

    public void setDashboardPreferences(DashboardPreferences prefs) {
        this.setPreference(".dashcontent.portal.portlets.first", (Object)prefs.leftColumnPortletNames);
        this.setPreference(".dashcontent.portal.portlets.second", (Object)prefs.rightColumnPortletNames);
    }

    public String getResourceBrowserViewMode() {
        return (String)this.getPreference(".resource.browser.view", (Object)HubView.LIST.name());
    }

    public void setResourceBrowserViewMode(String mode) {
        this.setPreference(".resource.browser.view", (Object)mode);
    }

    public SavedChartsPortletPreferences getSavedChartsPortletPreferences() {
        SavedChartsPortletPreferences prefs = new SavedChartsPortletPreferences();
        prefs.chartList = new ArrayList();
        int counter = 0;
        String chart = null;
        boolean errorOccurred = false;
        do {
            String preferenceName = ".dashContent.charts." + counter;
            try {
                chart = (String)this.getPreference(preferenceName, null);
                if (chart != null && !chart.equals("")) {
                    String[] nameURL = chart.split(",");
                    if (nameURL.length != 2) {
                        this.log.error((Object)("Could not read saved chart, marked for removal: '" + chart + "'"));
                        errorOccurred = true;
                    } else {
                        nameURL[0] = StringUtil.replace((String)nameURL[0], (String)"&#124;", (String)"|");
                        nameURL[0] = StringUtil.replace((String)nameURL[0], (String)"&#44;", (String)",");
                        nameURL[1] = StringUtil.replace((String)nameURL[1], (String)"&#124;", (String)"|");
                        nameURL[1] = StringUtil.replace((String)nameURL[1], (String)"&#44;", (String)",");
                        prefs.chartList.add(counter, new Tuple((Object)nameURL[0], (Object)nameURL[1]));
                    }
                }
            }
            catch (Exception e) {
                errorOccurred = true;
                this.log.warn((Object)("Error reading SavedChartsPortletPreferences for preference[name=" + preferenceName + "]: " + e.getMessage()));
            }
            ++counter;
        } while (chart != null && !chart.equals(""));
        if (errorOccurred) {
            this.setSavedChartsPortletPreferences(prefs);
        }
        Collections.sort(prefs.chartList, new SavedChartsPortletPreferences.ChartsComparator());
        return prefs;
    }

    public void setSavedChartsPortletPreferences(SavedChartsPortletPreferences prefs) {
        int counter = 0;
        String prevChart = null;
        do {
            if ((prevChart = (String)this.getPreference(".dashContent.charts." + counter, null)) != null && !prevChart.equals("")) {
                this.unsetPreference(".dashContent.charts." + counter);
            }
            ++counter;
        } while (prevChart != null && !prevChart.equals(""));
        counter = 0;
        for (Tuple nameURL : prefs.chartList) {
            nameURL.lefty = StringUtil.replace((String)((String)nameURL.lefty), (String)"|", (String)"&#124;");
            nameURL.lefty = StringUtil.replace((String)((String)nameURL.lefty), (String)",", (String)"&#44;");
            nameURL.righty = StringUtil.replace((String)((String)nameURL.righty), (String)"|", (String)"&#124;");
            nameURL.righty = StringUtil.replace((String)((String)nameURL.righty), (String)",", (String)"&#44;");
            this.setPreference(".dashContent.charts." + counter, (Object)((String)nameURL.lefty + "," + (String)nameURL.righty));
            ++counter;
        }
    }

    private boolean removeDeletedResources(List<Integer> resourceIds) {
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        int[] ids = ArrayUtils.unwrapCollection(resourceIds);
        List flyWeights = resourceManager.findFlyWeights(ids);
        boolean removed = false;
        for (int i = resourceIds.size() - 1; i >= 0; --i) {
            Integer resourceIdToVerify = resourceIds.get(i);
            boolean match = false;
            for (int j = 0; j < flyWeights.size(); ++j) {
                ResourceIdFlyWeight resourceFlyToCompare = (ResourceIdFlyWeight)flyWeights.get(j);
                if (resourceIdToVerify.intValue() != resourceFlyToCompare.getId()) continue;
                match = true;
                break;
            }
            if (match) continue;
            resourceIds.remove(i);
            removed = true;
        }
        return removed;
    }

    private boolean removeDeletedGroups(List<Integer> groupIds) {
        ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
        List deletedGroupIds = groupManager.findDeletedResourceGroupIds(ArrayUtils.unwrapCollection(groupIds));
        for (Integer deletedGroupId : deletedGroupIds) {
            groupIds.remove(deletedGroupId);
        }
        return deletedGroupIds.size() > 0;
    }

    public PageControl getPageControl(PageControlView view) {
        PageControl results = this.getPageControl(view, 15);
        this.log.debug((Object)("getPageControl(" + view + ") " + results));
        return results;
    }

    public PageControl getPageControl(PageControlView view, int defaultPageSize) {
        if (view == PageControlView.NONE) {
            this.log.debug((Object)("getPageControl(" + view + ") -> PageControl.getUnlimitedInstance()"));
            return PageControl.getUnlimitedInstance();
        }
        List pageControlProperties = this.getPreferenceAsList(view.toString());
        this.log.debug((Object)("getPageControl(" + view + ") -> pageControlProperties: " + pageControlProperties));
        if (pageControlProperties.size() == 0) {
            this.log.debug((Object)("getPageControl(" + view + ") -> getDefaultPageControl for empty properties"));
            PageControl defaultControl = this.getDefaultPageControl(view, defaultPageSize);
            return defaultControl;
        }
        PageControl pageControl = null;
        try {
            int pageSize = Integer.valueOf((String)pageControlProperties.get(0));
            int pageNumber = Integer.valueOf((String)pageControlProperties.get(1));
            pageControl = new PageControl(pageNumber, pageSize);
            for (int i = 3; i < pageControlProperties.size(); i += 2) {
                String pageOrdering = (String)pageControlProperties.get(i - 1);
                String sortColumn = (String)pageControlProperties.get(i);
                pageControl.addDefaultOrderingField(sortColumn, PageOrdering.valueOf((String)pageOrdering));
            }
            this.log.debug((Object)("getPageControl(" + view + ") -> " + pageControl));
            if (view.isUnlimited() && pageSize != -1) {
                pageControl.setPageSize(-1);
                this.setPageControl(view, pageControl);
            }
        }
        catch (Throwable t) {
            this.log.debug((Object)("getPageControl(" + view + ") -> getDefaultPageControl for exception: " + t.getMessage()));
            pageControl = this.getDefaultPageControl(view, defaultPageSize);
        }
        return pageControl;
    }

    public PageControl getDefaultPageControl(PageControlView view, int defaultPageSize) {
        PageControl defaultPageControl = null;
        defaultPageControl = view.isUnlimited() ? PageControl.getUnlimitedInstance() : new PageControl(0, defaultPageSize);
        this.setPageControl(view, defaultPageControl);
        return defaultPageControl;
    }

    public void setPageControl(PageControlView view, PageControl pageControl) {
        if (view == PageControlView.NONE) {
            return;
        }
        ArrayList<Object> pageControlProperties = new ArrayList<Object>();
        pageControlProperties.add(pageControl.getPageSize());
        pageControlProperties.add(pageControl.getPageNumber());
        for (OrderingField field : pageControl.getOrderingFieldsAsArray()) {
            pageControlProperties.add(field.getOrdering().toString());
            pageControlProperties.add(field.getField());
        }
        this.log.debug((Object)("setPageControl(" + view + ", " + pageControl + ")"));
        this.setPreference(view.toString(), pageControlProperties);
    }

    public void addRecentResource(ResourceVisit visit) {
        List visits = this.getRecentResourceVisits();
        ListIterator iter = visits.listIterator();
        while (iter.hasNext()) {
            if (!((ResourceVisit)iter.next()).equals((Object)visit)) continue;
            iter.remove();
            break;
        }
        visits.add(0, visit);
        if (visits.size() > 10) {
            visits.remove(10);
        }
        this.setPreference(".recent.resources", visits, ",");
    }

    public List<ResourceVisit> getRecentResourceVisits() {
        ArrayList<ResourceVisit> visits = new ArrayList<ResourceVisit>();
        try {
            List resourceIds = this.getPreferenceAsIntegerList(".recent.resources", "|");
            for (Integer resourceId : resourceIds) {
                ResourceVisit visit = new ResourceVisit(resourceId.intValue(), "", ResourceVisit.Kind.resource);
                visits.add(visit);
            }
        }
        catch (RuntimeException e) {
            List stringList = this.getPreferenceAsList(".recent.resources", ",");
            for (String string : stringList) {
                String[] data = string.split("\\|");
                if (data.length != 3) {
                    throw new RuntimeException("Failed to parse resource visit item: " + string);
                }
                ResourceVisit.Kind kind = ResourceVisit.Kind.valueOf((String)data[1]);
                if (kind != ResourceVisit.Kind.resource && kind != ResourceVisit.Kind.PLATFORM && kind != ResourceVisit.Kind.SERVER && kind != ResourceVisit.Kind.SERVICE) continue;
                int resourceId = Integer.parseInt(data[0]);
                ResourceVisit visit = new ResourceVisit(resourceId, "", ResourceVisit.Kind.resource);
                visits.add(visit);
            }
            this.setPreference(".recent.resources", visits, "|");
        }
        return visits;
    }
}

