/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.util;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jvnet.inflector.Rule;
import org.jvnet.inflector.RuleBasedPluralizer;
import org.jvnet.inflector.rule.AbstractRegexReplacementRule;
import org.jvnet.inflector.rule.CategoryInflectionRule;
import org.jvnet.inflector.rule.IrregularMappingRule;
import org.jvnet.inflector.rule.RegexReplacementRule;
import org.jvnet.inflector.rule.SuffixInflectionRule;

public class CustomEnglishPluralizer
extends RuleBasedPluralizer {
    private static final String POSTFIX_ADJECTIVE_REGEX = "((?!major|lieutenant|brigadier|adjutant)\\S+(?=(?:-|\\s+)general)|court(?=(?:-|\\s+)martial))(.*)";
    private static final String[] PREPOSITIONS = new String[]{"about", "above", "across", "after", "among", "around", "at", "athwart", "before", "behind", "below", "beneath", "beside", "besides", "between", "betwixt", "beyond", "but", "by", "during", "except", "for", "from", "in", "into", "near", "of", "off", "on", "onto", "out", "over", "since", "till", "to", "under", "until", "unto", "upon", "with"};
    private static final Map<String, String> NOMINATIVE_PRONOUNS = IrregularMappingRule.toMap((String[][])new String[][]{{"i", "we"}, {"myself", "ourselves"}, {"you", "you"}, {"yourself", "yourselves"}, {"she", "they"}, {"herself", "themselves"}, {"he", "they"}, {"himself", "themselves"}, {"it", "they"}, {"itself", "themselves"}, {"they", "they"}, {"themself", "themselves"}, {"mine", "ours"}, {"yours", "yours"}, {"hers", "theirs"}, {"his", "theirs"}, {"its", "theirs"}, {"theirs", "theirs"}});
    private static final Map<String, String> ACCUSATIVE_PRONOUNS = IrregularMappingRule.toMap((String[][])new String[][]{{"me", "us"}, {"myself", "ourselves"}, {"you", "you"}, {"yourself", "yourselves"}, {"her", "them"}, {"herself", "themselves"}, {"him", "them"}, {"himself", "themselves"}, {"it", "them"}, {"itself", "themselves"}, {"them", "them"}, {"themself", "themselves"}});
    private static final Map<String, String> IRREGULAR_NOUNS = IrregularMappingRule.toMap((String[][])new String[][]{{"child", "children"}, {"brother", "brothers"}, {"loaf", "loaves"}, {"hoof", "hoofs"}, {"beef", "beefs"}, {"money", "monies"}, {"mongoose", "mongooses"}, {"ox", "oxen"}, {"cow", "cows"}, {"soliloquy", "soliloquies"}, {"graffito", "graffiti"}, {"prima donna", "prima donnas"}, {"octopus", "octopuses"}, {"genie", "genies"}, {"ganglion", "ganglions"}, {"trilby", "trilbys"}, {"turf", "turfs"}, {"numen", "numina"}, {"atman", "atmas"}, {"occiput", "occiputs"}, {"corpus", "corpuses"}, {"opus", "opuses"}, {"genus", "genera"}, {"mythos", "mythoi"}, {"penis", "penises"}, {"testis", "testes"}, {"atlas", "atlases"}});
    private static final String[] CATEGORY_UNINFLECTED_NOUNS = new String[]{".*fish", "tuna", "salmon", "mackerel", "trout", "bream", "sea[- ]bass", "carp", "cod", "flounder", "whiting", ".*deer", ".*sheep", "Portuguese", "Amoyese", "Borghese", "Congoese", "Faroese", "Foochowese", "Genevese", "Genoese", "Gilbertese", "Hottentotese", "Kiplingese", "Kongoese", "Lucchese", "Maltese", "Nankingese", "Niasese", "Pekingese", "Piedmontese", "Pistoiese", "Sarawakese", "Shavese", "Vermontese", "Wenchowese", "Yengeese", ".*[nrlm]ese", ".*pox", "graffiti", "djinn", "breeches", "britches", "clippers", "gallows", "hijinks", "headquarters", "pliers", "scissors", "testes", "herpes", "pincers", "shears", "proceedings", "trousers", "cantus", "coitus", "nexus", "contretemps", "corps", "debris", ".*ois", "siemens", ".*measles", "mumps", "diabetes", "jackanapes", "series", "species", "rabies", "chassis", "innings", "news", "mews"};
    private static final String[] CATEGORY_MAN_MANS_RULE = new String[]{"human", "Alabaman", "Bahaman", "Burman", "German", "Hiroshiman", "Liman", "Nakayaman", "Oklahoman", "Panaman", "Selman", "Sonaman", "Tacoman", "Yakiman", "Yokohaman", "Yuman"};
    private static final String[] CATEGORY_EX_ICES_RULE = new String[]{"codex", "murex", "silex"};
    private static final String[] CATEGORY_IX_ICES_RULE = new String[]{"radix", "helix"};
    private static final String[] CATEGORY_UM_A_RULE = new String[]{"bacterium", "agendum", "desideratum", "erratum", "stratum", "datum", "ovum", "extremum", "candelabrum"};
    private static final String[] CATEGORY_US_I_RULE = new String[]{"alumnus", "alveolus", "bacillus", "bronchus", "locus", "nucleus", "stimulus", "meniscus"};
    private static final String[] CATEGORY_ON_A_RULE = new String[]{"criterion", "perihelion", "aphelion", "phenomenon", "prolegomenon", "noumenon", "organon", "asyndeton", "hyperbaton"};
    private static final String[] CATEGORY_A_AE_RULE = new String[]{"alumna", "alga", "vertebra", "persona"};
    private static final String[] CATEGORY_O_OS_RULE = new String[]{"albino", "archipelago", "armadillo", "commando", "crescendo", "fiasco", "ditto", "dynamo", "embryo", "ghetto", "guano", "inferno", "jumbo", "lumbago", "magneto", "manifesto", "medico", "octavo", "photo", "pro", "quarto", "canto", "lingo", "generalissimo", "stylo", "rhino", "casino", "auto", "macro", "zero", "solo", "soprano", "basso", "alto", "contralto", "tempo", "piano", "virtuoso"};
    private static final String[] CATEGORY_SINGULAR_S_RULE = new String[]{".*ss", "acropolis", "aegis", "alias", "asbestos", "bathos", "bias", "bronchitis", "bursitis", "caddis", "cannabis", "canvas", "chaos", "cosmos", "dais", "digitalis", "epidermis", "ethos", "eyas", "gas", "glottis", "hubris", "ibis", "lens", "mantis", "marquis", "metropolis", "pathos", "pelvis", "polis", "rhinoceros", "sassafras", "trellis", ".*us", "[A-Z].*es", "ephemeris", "iris", "clitoris", "chrysalis", "epididymis", ".*itis"};
    private final List<Rule> rules = Arrays.asList(new RegexReplacementRule("^(\\s)$", "$1"), new CategoryInflectionRule(CATEGORY_UNINFLECTED_NOUNS, "-", "-"), new /* Unavailable Anonymous Inner Class!! */, new /* Unavailable Anonymous Inner Class!! */, new /* Unavailable Anonymous Inner Class!! */, new IrregularMappingRule(NOMINATIVE_PRONOUNS, "(?i)" + AbstractRegexReplacementRule.disjunction(NOMINATIVE_PRONOUNS.keySet())), new IrregularMappingRule(ACCUSATIVE_PRONOUNS, "(?i)" + AbstractRegexReplacementRule.disjunction(ACCUSATIVE_PRONOUNS.keySet())), new /* Unavailable Anonymous Inner Class!! */, new IrregularMappingRule(IRREGULAR_NOUNS, "(?i)(.*)\\b" + AbstractRegexReplacementRule.disjunction(IRREGULAR_NOUNS.keySet()) + "$"), new CategoryInflectionRule(CATEGORY_MAN_MANS_RULE, "-man", "-mans"), new RegexReplacementRule("(?i)(\\S*)(person)$", "$1people"), new SuffixInflectionRule("-man", "-man", "-men"), new SuffixInflectionRule("-[lm]ouse", "-ouse", "-ice"), new SuffixInflectionRule("-tooth", "-tooth", "-teeth"), new SuffixInflectionRule("-goose", "-goose", "-geese"), new SuffixInflectionRule("-foot", "-foot", "-feet"), new SuffixInflectionRule("-ceps", "-", "-"), new SuffixInflectionRule("-zoon", "-zoon", "-zoa"), new SuffixInflectionRule("-[csx]is", "-is", "-es"), new CategoryInflectionRule(CATEGORY_EX_ICES_RULE, "-ex", "-ices"), new CategoryInflectionRule(CATEGORY_IX_ICES_RULE, "-ix", "-ices"), new CategoryInflectionRule(CATEGORY_UM_A_RULE, "-um", "-a"), new CategoryInflectionRule(CATEGORY_US_I_RULE, "-us", "-i"), new CategoryInflectionRule(CATEGORY_ON_A_RULE, "-on", "-a"), new CategoryInflectionRule(CATEGORY_A_AE_RULE, "-a", "-ae"), new CategoryInflectionRule(CATEGORY_SINGULAR_S_RULE, "-s", "-ses"), new RegexReplacementRule("^([A-Z].*s)$", "$1es"), new SuffixInflectionRule("-[cs]h", "-h", "-hes"), new SuffixInflectionRule("-x", "-x", "-xes"), new SuffixInflectionRule("-z", "-z", "-zes"), new SuffixInflectionRule("-[aeo]lf", "-f", "-ves"), new SuffixInflectionRule("-[^d]eaf", "-f", "-ves"), new SuffixInflectionRule("-arf", "-f", "-ves"), new SuffixInflectionRule("-[nlw]ife", "-fe", "-ves"), new SuffixInflectionRule("-[aeiou]y", "-y", "-ys"), new SuffixInflectionRule("-y", "-y", "-ies"), new CategoryInflectionRule(CATEGORY_O_OS_RULE, "-o", "-os"), new SuffixInflectionRule("-[aeiou]o", "-o", "-os"), new SuffixInflectionRule("-o", "-o", "-oes"), new SuffixInflectionRule("-", "-s"));

    public CustomEnglishPluralizer() {
        this.setRules(this.rules);
        this.setLocale(Locale.ENGLISH);
    }

    protected String postProcess(String trimmedWord, String pluralizedWord) {
        return pluralizedWord;
    }
}

