/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.user;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.gui.admin.user.AddUserRolesForm;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.BaseValidatorForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.util.LookupUtil;

public class AddUserRolesAction
extends BaseAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog((String)AddUserRolesAction.class.getName());
        HttpSession session = request.getSession();
        AddUserRolesForm addForm = (AddUserRolesForm)form;
        Integer userId = addForm.getU();
        ActionForward forward = this.checkSubmit(request, mapping, form, "u", (Object)userId);
        if (forward != null) {
            BaseValidatorForm spiderForm = (BaseValidatorForm)form;
            if (spiderForm.isCancelClicked() || spiderForm.isResetClicked()) {
                log.trace((Object)"removing pending roles list");
                SessionUtils.removeList((HttpSession)session, (String)"PendingSessionRoles");
            } else if (spiderForm.isAddClicked()) {
                log.trace((Object)"adding to pending roles list");
                SessionUtils.addToList((HttpSession)session, (String)"PendingSessionRoles", (Integer[])addForm.getAvailableRoles());
            } else if (spiderForm.isRemoveClicked()) {
                log.trace((Object)"removing from pending roles list");
                SessionUtils.removeFromList((HttpSession)session, (String)"PendingSessionRoles", (Integer[])addForm.getPendingRoles());
            }
            return forward;
        }
        Subject user = LookupUtil.getSubjectManager().getSubjectById(userId.intValue());
        if (user == null) {
            throw new NullPointerException("User [" + userId + "] is not known");
        }
        log.trace((Object)"getting pending role list");
        int[] pendingRoleIds = ArrayUtils.unwrapArray((Integer[])SessionUtils.getList((HttpSession)request.getSession(), (String)"PendingSessionRoles"));
        for (int i = 0; i < pendingRoleIds.length; ++i) {
            log.trace((Object)("adding role [" + pendingRoleIds[i] + "] for user [" + userId + "]"));
        }
        try {
            LookupUtil.getRoleManager().addRolesToSubject(RequestUtils.getSubject((HttpServletRequest)request), user.getId(), pendingRoleIds);
        }
        catch (PermissionException pe) {
            RequestUtils.setError((HttpServletRequest)request, (String)"admin.role.error.StaticRole");
            ActionForward actionForward = this.returnFailure(request, mapping, "u", (Object)userId);
            return actionForward;
        }
        finally {
            log.trace((Object)"removing pending user list");
            SessionUtils.removeList((HttpSession)session, (String)"PendingSessionRoles");
        }
        RequestUtils.setConfirmation((HttpServletRequest)request, (String)"admin.user.confirm.AddRoles");
        return this.returnSuccess(request, mapping, "u", (Object)userId, false);
    }
}

