/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.enterprise.gui.image.WebImage;
import org.rhq.enterprise.gui.image.chart.ChartGraphics;
import org.rhq.enterprise.gui.image.chart.DataPointCollection;
import org.rhq.enterprise.gui.image.data.IDisplayDataPoint;
import org.rhq.enterprise.gui.image.data.IHighLowDataPoint;
import org.rhq.enterprise.gui.image.data.IStackedDataPoint;

public abstract class Chart
extends WebImage {
    private Log log = LogFactory.getLog((String)Chart.class.getName());
    public static final String EMPTY_STRING = "";
    protected static final String ARG_MUST_BE_ZERO_OR_GREATER = "Argument value must be zero or greater";
    protected static final String AVG = "Average";
    protected static final String BASELINE = "Baseline";
    protected static final String LOW = "Low";
    protected static final String PEAK = "Peak";
    protected static final String DEFAULT_UNIT_LEGEND = "TIME";
    protected static final String DEFAULT_VALUE_LEGEND = "VALUE";
    private static final String NO_DATA = "No Metric Data Available";
    private static final int DEFAULT_LINE_WIDTH = 1;
    private static final int DEFAULT_VALUE_INDENT = 0;
    private static final int DEFAULT_VALUE_LINES = 11;
    private static final int DEFAULT_TEXT_WHITESPACE = 3;
    private static final int DEFAULT_TICK_MARK_HEIGHT = 6;
    protected static final int VARIABLE_HEIGHT = Integer.MIN_VALUE;
    protected static final int VARIABLE_WIDTH = Integer.MIN_VALUE;
    private static final Color DEFAULT_FRAME_COLOR = new Color(230, 229, 229);
    private static final Color DEFAULT_LEGEND_TEXT_COLOR = Color.BLACK;
    private static final Color DEFAULT_X_LINE_COLOR = new Color(230, 229, 229);
    private static final Color DEFAULT_TEXT_COLOR = new Color(128, 128, 128);
    private static final Color DEFAULT_AVERAGE_COLOR = new Color(140, 191, 115);
    private static final Color DEFAULT_BASELINE_COLOR = new Color(191, 178, 115);
    private static final Color DEFAULT_LOW_COLOR = new Color(115, 191, 179);
    private static final Color DEFAULT_PEAK_COLOR = new Color(217, 152, 152);
    private static final Color DEFAULT_HIGH_RANGE_COLOR = new Color(247, 235, 235);
    private static final Color DEFAULT_LOW_RANGE_COLOR = new Color(235, 247, 246);
    protected static final Font DEFAULT_LABEL_FONT = new Font("Helvetica", 0, 10);
    protected static final Font DEFAULT_LEGEND_PLAIN = new Font("Helvetica", 0, 11);
    protected static final Font DEFAULT_LEGEND_FONT = new Font("Helvetica", 1, 11);
    protected FontMetrics m_metricsLabel;
    protected FontMetrics m_metricsLegend;
    private String m_strUnitLegend = "TIME";
    private String m_strValueLegend = "VALUE";
    private Color m_clrFrame = DEFAULT_FRAME_COLOR;
    private Color m_clrLegendText = DEFAULT_LEGEND_TEXT_COLOR;
    protected MeasurementUnits m_fmtUnits;
    protected double m_dAvgValue = 0.0;
    protected double m_dLowValue = Double.POSITIVE_INFINITY;
    protected double m_dPeakValue = Double.NEGATIVE_INFINITY;
    protected double[] m_adRangeMarks;
    protected double m_floor;
    protected boolean m_bNoData;
    private String m_strTitle = "";
    private ArrayList<DataPointCollection> m_collDataPointColl = new ArrayList(1);
    private String m_strNoData = "No Metric Data Available";
    public int yTopLegend;
    public int yBottomLegend;
    public int xVertLegend;
    public int yHorzLabels;
    public int x2VertLabels;
    public int xRLabel;
    public int xVertMarks;
    public int x2VertMarks;
    public int xLabelsSkip = 4;
    public Color averageLineColor = DEFAULT_AVERAGE_COLOR;
    public Color baselineColor = DEFAULT_BASELINE_COLOR;
    public double ceiling = 0.0;
    public Color chartColor = Color.WHITE;
    public double floor = 0.0;
    public double baseline = 0.0;
    public double highRange = Double.NaN;
    public Color highRangeColor = DEFAULT_HIGH_RANGE_COLOR;
    public Font legendFont = DEFAULT_LEGEND_FONT;
    public Color legendTextColor = DEFAULT_LEGEND_TEXT_COLOR;
    public int lineWidth = 1;
    public Color lowLineColor = DEFAULT_LOW_COLOR;
    public double lowRange = Double.NaN;
    public Color lowRangeColor = DEFAULT_LOW_RANGE_COLOR;
    public Color peakLineColor = DEFAULT_PEAK_COLOR;
    public int rightLabelWidth = -1;
    public boolean showAverage = false;
    public boolean showBaseline = false;
    public boolean showBottomLabels = true;
    public boolean showBottomLegend = true;
    public boolean showFullLabels = false;
    public boolean showHighRange = false;
    public boolean showLeftLabels = true;
    public boolean showLeftLegend = true;
    public boolean showLow = false;
    public boolean showLowRange = false;
    public boolean showPeak = false;
    public boolean showRightLabels = true;
    public boolean showRightLegend = false;
    public boolean showTopLabels = false;
    public boolean showTopLegend = false;
    public boolean showUnitLines = false;
    public boolean showValueLines = false;
    public boolean showValues = true;
    public int textWhitespace = 3;
    public int tickMarkHeight = 6;
    public int valueIndent = 0;
    public int valueLines = 11;
    public Color xLineColor = DEFAULT_X_LINE_COLOR;
    public int xOffset = 0;
    public int yOffset = 0;

    protected Chart() {
        this(1);
    }

    protected Chart(int charts) {
        this(755, 300, charts);
    }

    protected Chart(int width, int height) {
        this(width, height, 1);
    }

    protected Chart(int width, int height, int charts) {
        super(width, height);
        this.shadowWidth = 0;
        this.textColor = DEFAULT_TEXT_COLOR;
        if (charts <= 0) {
            charts = 1;
        }
        this.setNumberDataSets(charts);
        this.initFonts();
    }

    protected void draw(Graphics2D g) {
        super.draw(g);
        this.draw(new ChartGraphics(this, g));
    }

    protected Rectangle draw(ChartGraphics g) {
        Rectangle rect = this.getInteriorRectangle(g);
        if (!this.m_bNoData) {
            g.graphics.setColor(this.m_clrFrame);
            g.graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
            g.graphics.setColor(this.chartColor);
            g.graphics.fillRect(rect.x + this.lineWidth, rect.y + this.lineWidth, rect.width - this.lineWidth, rect.height - this.lineWidth);
        } else {
            FontMetrics metrics = g.graphics.getFontMetrics(this.legendFont);
            g.graphics.setColor(this.m_clrLegendText);
            g.graphics.setFont(DEFAULT_LEGEND_PLAIN);
            g.graphics.drawString(this.m_strNoData, this.width / 2 - metrics.stringWidth(this.m_strNoData) / 2, this.yOffset + this.height / 2 + metrics.getAscent() / 2);
        }
        return rect;
    }

    protected void calc(Graphics2D g) {
        int yHorzMarks;
        int cxLabels;
        Rectangle rect = new Rectangle(this.xOffset, this.yOffset, this.width, this.height);
        rect.x += this.leftBorder;
        if (this.showHighRange || this.showLowRange) {
            rect.x += this.lineWidth;
        }
        int xVertLabels = this.showLeftLegend ? rect.x + this.m_metricsLegend.charWidth('V') + this.textWhitespace * 2 : 0;
        int n = cxLabels = this.rightLabelWidth < 0 ? this.getYLabelWidth(g) : this.rightLabelWidth;
        if (this.showLeftLabels) {
            this.x2VertLabels = xVertLabels + cxLabels;
            this.xVertMarks = this.x2VertLabels + this.textWhitespace;
            rect.x = this.xVertMarks + this.tickMarkHeight;
        }
        rect.width = rect.width - rect.x - this.rightBorder;
        if (this.showRightLabels) {
            rect.width -= this.tickMarkHeight;
            rect.width -= cxLabels;
        } else {
            String[] labels = this.getXLabels();
            if (labels != null && labels.length > 1) {
                rect.width -= this.m_metricsLabel.stringWidth(labels[labels.length - 1]) / 2;
            }
        }
        this.adjustRectangle(g, rect);
        this.x2VertMarks = rect.x + rect.width + this.lineWidth * 2;
        if (this.showRightLabels) {
            this.x2VertMarks += this.tickMarkHeight;
        }
        this.xRLabel = this.x2VertMarks + this.textWhitespace;
        rect.y += this.topBorder;
        if (this.showTopLegend) {
            rect.y += this.m_metricsLegend.getAscent();
            this.yTopLegend = rect.y;
            rect.y += this.textWhitespace;
        }
        if (this.showTopLabels) {
            rect.y += this.getXLabelHeight() + this.tickMarkHeight;
        }
        if (!this.showTopLegend && !this.showTopLabels) {
            rect.y += this.m_metricsLabel.getAscent() / 2;
        }
        this.yBottomLegend = this.yOffset + (rect.height - this.bottomBorder);
        if (!this.showBottomLegend && !this.showBottomLabels) {
            yHorzMarks = this.yHorzLabels = this.yBottomLegend - this.m_metricsLabel.getAscent() / 2;
        } else {
            this.yHorzLabels = this.yBottomLegend - (this.showBottomLegend ? this.getXLabelHeight() : 0);
            yHorzMarks = this.yHorzLabels - (this.showBottomLabels ? this.m_metricsLabel.getAscent() + this.tickMarkHeight : 0);
        }
        int y2Rect = yHorzMarks - this.lineWidth;
        rect.height = y2Rect - rect.y;
    }

    protected Rectangle adjustRectangle(Graphics2D g, Rectangle rect) {
        return rect;
    }

    protected void calcRanges() {
        double unit;
        int cActualVals = 0;
        Iterator iterDataSet = this.m_collDataPointColl.iterator();
        while (iterDataSet.hasNext()) {
            for (IDisplayDataPoint datapt : (DataPointCollection)iterDataSet.next()) {
                double[] dArray;
                if (Double.isNaN(datapt.getValue())) continue;
                if (this.checkHighLow() && datapt instanceof IHighLowDataPoint) {
                    IHighLowDataPoint hlPt = (IHighLowDataPoint)datapt;
                    if (!Double.isNaN(hlPt.getLowValue())) {
                        this.m_dLowValue = Math.min(this.m_dLowValue, hlPt.getLowValue());
                    }
                    if (!Double.isNaN(hlPt.getHighValue())) {
                        this.m_dPeakValue = Math.max(this.m_dPeakValue, hlPt.getHighValue());
                    }
                }
                if (datapt instanceof IStackedDataPoint) {
                    dArray = ((IStackedDataPoint)datapt).getValues();
                } else {
                    double[] dArray2 = new double[1];
                    dArray = dArray2;
                    dArray2[0] = datapt.getValue();
                }
                double[] vals = dArray;
                for (int i = 0; i < vals.length; ++i) {
                    double dVal = vals[i];
                    this.m_dAvgValue += dVal;
                    ++cActualVals;
                    this.m_dLowValue = Math.min(this.m_dLowValue, dVal);
                    this.m_dPeakValue = Math.max(this.m_dPeakValue, dVal);
                }
            }
        }
        boolean bl = this.m_bNoData = cActualVals == 0;
        if (this.m_bNoData) {
            this.m_adRangeMarks = new double[0];
            return;
        }
        this.m_dAvgValue /= (double)cActualVals;
        if (this.ceiling == this.floor) {
            double topRange;
            double range = this.m_dPeakValue - this.m_dLowValue;
            if (range != 0.0) {
                double buffer = range * 0.1;
                double topbuf = buffer / 2.0;
                double botbuf = this.m_dLowValue - topbuf < 0.0 ? this.m_dLowValue : topbuf;
                unit = (range += topbuf + botbuf) / (double)(this.valueLines - 1);
                this.m_floor = this.m_dLowValue - botbuf;
                topRange = this.m_dPeakValue + topbuf;
            } else {
                this.m_floor = 0.0;
                if (this.m_dPeakValue == 0.0) {
                    topRange = this.valueLines - 1;
                    if (this.m_fmtUnits.getFamily() == MeasurementUnits.Family.DURATION) {
                        topRange *= 1000.0;
                    }
                } else {
                    topRange = this.m_dPeakValue * 2.0;
                }
                unit = (topRange - this.m_floor) / (double)(this.valueLines - 1);
            }
        } else {
            this.m_floor = this.floor;
            unit = (this.ceiling - this.floor) / (double)(this.valueLines - 1);
        }
        this.m_adRangeMarks = new double[this.valueLines];
        for (int i = 0; i < this.valueLines; ++i) {
            this.m_adRangeMarks[i] = this.m_floor + (double)i * unit;
        }
    }

    protected int calcVariableHeight() {
        return this.height;
    }

    protected int calcVariableWidth() {
        return this.width;
    }

    protected int getXLabelWidth() {
        int iMaxWidth = 0;
        Iterator iter = this.getDataPoints().iterator();
        while (iter.hasNext()) {
            int iWidth = this.m_metricsLabel.stringWidth(((IDisplayDataPoint)iter.next()).getLabel());
            if (iWidth <= iMaxWidth) continue;
            iMaxWidth = iWidth;
        }
        return iMaxWidth;
    }

    protected int getXLegendHeight() {
        int height = this.m_metricsLegend.getAscent() + this.textWhitespace * 2;
        int result = 0;
        if (this.showTopLegend) {
            result += height;
        }
        if (this.showBottomLegend) {
            result += height;
        }
        return result;
    }

    protected abstract int getYLabelWidth(Graphics2D var1);

    protected abstract String[] getXLabels();

    protected int getXLabelHeight() {
        int result = 0;
        if (this.showTopLabels || this.showBottomLabels) {
            String[] labels = this.getXLabels();
            int labelHeight = 0;
            labelHeight = labels != null && labels.length > 0 ? this.tickMarkHeight + ChartGraphics.getStringHeight((String)labels[0], (FontMetrics)this.m_metricsLabel) : this.tickMarkHeight + this.m_metricsLabel.getAscent();
            if (this.showTopLabels) {
                result += labelHeight;
            }
            if (this.showBottomLabels) {
                result += labelHeight;
            }
        }
        return result;
    }

    protected abstract Rectangle getInteriorRectangle(ChartGraphics var1);

    protected int getExteriorHeight() {
        int cyLabel = this.getXLabelHeight();
        int cyLegend = this.getXLegendHeight();
        int cyBuf = this.m_metricsLabel.getAscent() / 2;
        if (!this.showBottomLabels && !this.showBottomLegend) {
            cyBuf += this.m_metricsLabel.getAscent() / 2;
        }
        return this.topBorder + cyLegend + cyLabel + cyBuf + this.bottomBorder;
    }

    protected Collection<DataPointCollection> initData(Collection<DataPointCollection> coll) {
        return coll;
    }

    protected void initFonts() {
        BufferedImage img = new BufferedImage(1, 1, 12);
        Graphics2D g = (Graphics2D)((Image)img).getGraphics();
        this.m_metricsLabel = g.getFontMetrics(this.font);
        this.m_metricsLegend = g.getFontMetrics(this.legendFont);
        g.dispose();
    }

    protected void preInit() {
        Collection coll = this.initData((Collection)this.m_collDataPointColl);
        if (!(coll instanceof ArrayList)) {
            throw new ClassCastException("initData() must return a collection of type ArrayList.");
        }
        this.m_collDataPointColl = (ArrayList)coll;
        if (this.height == Integer.MIN_VALUE) {
            this.height = this.calcVariableHeight();
        }
        if (this.width == Integer.MIN_VALUE) {
            this.width = this.calcVariableWidth();
        }
    }

    protected void postInit(Graphics2D g) {
        this.calcRanges();
        this.calc(g);
    }

    protected Point getDataPoint(int valuePixels, int unitPixels, int datapoint, DataPointCollection coll) {
        int cDataPts = coll.size();
        double dVal = ((IDisplayDataPoint)coll.get(datapoint)).getValue();
        return this.getDisplayPoint(valuePixels, unitPixels, cDataPts, dVal, datapoint);
    }

    protected Point getDisplayPoint(int valuePixels, int unitPixels, int unitPoints, double value, int unitIndex) {
        int iSpread = unitPixels - this.valueIndent * 2;
        int n = iSpread = unitPoints > 1 ? iSpread / (unitPoints - 1) : iSpread;
        if (Double.isNaN(value)) {
            return null;
        }
        if (this.ceiling != this.floor) {
            if (value < this.floor) {
                this.log.error((Object)("Data point value (" + value + ") lower than floor (" + this.floor + ")"));
                value = this.floor;
            } else if (value > this.ceiling) {
                this.log.error((Object)("Data point value (" + value + ") higher than ceiling (" + this.ceiling + ")"));
                value = this.ceiling;
            }
        }
        int x = this.valueIndent + iSpread * unitIndex;
        int y = valuePixels - (int)Math.round((value - this.m_floor) * this.scale(valuePixels));
        if (x == 0) {
            ++x;
        } else if (x == unitPixels - this.lineWidth) {
            --x;
        }
        if (y == 0) {
            ++y;
        } else if (y == valuePixels) {
            --y;
        }
        return new Point(x, y);
    }

    protected String getUnitLabel(IDisplayDataPoint data) {
        return data.getLabel();
    }

    protected boolean hasData() {
        return !this.m_bNoData;
    }

    protected double scale(int height) {
        double result = (double)height / (this.m_adRangeMarks[this.m_adRangeMarks.length - 1] - this.m_adRangeMarks[0]);
        return result;
    }

    protected Class<DataPointCollection> getDataCollectionClass() {
        return DataPointCollection.class;
    }

    protected boolean checkHighLow() {
        return false;
    }

    public double getAverageValue() {
        return this.m_dAvgValue;
    }

    public String getNoDataString() {
        return this.m_strNoData;
    }

    public void setNoDataString(String s) {
        this.m_strNoData = s == null ? EMPTY_STRING : s;
    }

    public DataPointCollection getDataPoints() {
        return this.getDataPoints(0);
    }

    public DataPointCollection getDataPoints(int index) {
        return (DataPointCollection)this.m_collDataPointColl.get(index);
    }

    public int getDataSetCount() {
        return this.m_collDataPointColl.size();
    }

    public Iterator<DataPointCollection> getDataSetIterator() {
        return this.m_collDataPointColl.iterator();
    }

    public void setNumberDataSets(int number) {
        int delta = number - this.m_collDataPointColl.size();
        if (delta > 0) {
            try {
                for (int i = 0; i < delta; ++i) {
                    this.m_collDataPointColl.add(this.getDataCollectionClass().newInstance());
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        } else if (delta < 0) {
            for (int i = delta; i < 0; ++i) {
                this.m_collDataPointColl.remove(this.m_collDataPointColl.size() - 1);
            }
        }
        if (this.getDataSetCount() == 0) {
            try {
                this.m_collDataPointColl.add(this.getDataCollectionClass().newInstance());
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public void setFormat(MeasurementUnits units) {
        this.m_fmtUnits = units;
    }

    public Rectangle getExteriorRectangle() {
        return new Rectangle(this.xOffset, this.yOffset, this.width, this.height);
    }

    public double getLowValue() {
        return this.m_dLowValue;
    }

    public double getPeakValue() {
        return this.m_dPeakValue;
    }

    public String getTitle() {
        return this.m_strTitle;
    }

    public void setTitle(String title) {
        this.m_strTitle = title == null ? EMPTY_STRING : title;
    }

    public String getUnitLegend() {
        return this.m_strUnitLegend;
    }

    public void setUnitLegend(String legend) {
        this.m_strUnitLegend = legend == null ? EMPTY_STRING : legend;
    }

    public String getValueLegend() {
        return this.m_strValueLegend;
    }

    public void setValueLegend(String legend) {
        this.m_strValueLegend = legend == null ? EMPTY_STRING : legend;
    }
}

