/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.Iterator;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.enterprise.gui.image.chart.Chart;
import org.rhq.enterprise.gui.image.chart.ChartGraphics;
import org.rhq.enterprise.gui.image.chart.DataPointCollection;
import org.rhq.enterprise.gui.image.chart.HorizontalChart;
import org.rhq.enterprise.gui.image.chart.PerfDataPointCollection;
import org.rhq.enterprise.gui.image.chart.PerformanceChart;

public class StackedPerformanceChart
extends HorizontalChart {
    private static String CALLS = "Calls: ";
    private static String SEMICOLON = ": ";
    private static String DEFAULT_DESTINATION_TYPE = "Destination";
    private static final int CHART_INDENT = 25;
    private static final Font DEFAULT_TITLE_FONT = new Font("Helvetica", 1, 11);
    private static final Font DEFAULT_TITLE_TEXT_FONT = new Font("Helvetica", 0, 11);
    private PerformanceChart m_perf;
    private int m_interiorHeight;
    private String m_destinationType;

    public StackedPerformanceChart() {
        this(755, Integer.MIN_VALUE);
    }

    public StackedPerformanceChart(int width, int charts) {
        this(width, Integer.MIN_VALUE, charts);
    }

    public StackedPerformanceChart(int width, int charts, String destinationType) {
        this(width, Integer.MIN_VALUE, charts, destinationType);
    }

    public StackedPerformanceChart(int width, int height, int charts) {
        this(width, height, charts, DEFAULT_DESTINATION_TYPE);
    }

    public StackedPerformanceChart(int width, int height, int charts, String destinationType) {
        super(width, Integer.MIN_VALUE, charts);
        this.m_interiorHeight = height;
        this.m_perf = new PerformanceChart(width, 1);
        this.m_perf.valueIndent = 8;
        this.m_perf.valueLines = 10;
        this.m_perf.setValueLegend("Call Time");
        this.m_destinationType = destinationType != null ? destinationType : DEFAULT_DESTINATION_TYPE;
    }

    protected void init() {
        super.init();
        this.showBottomLegend = false;
        this.showLeftLegend = false;
        this.topBorder = 0;
        this.bottomBorder = 0;
    }

    protected int calcVariableHeight() {
        int height = 0;
        if (this.m_interiorHeight == Integer.MIN_VALUE) {
            this.m_interiorHeight = 14 * this.getDataPoints().size() + this.lineWidth * 2;
        }
        Iterator iterBars = this.getDataSetIterator();
        int line = 0;
        while (iterBars.hasNext()) {
            PerfDataPointCollection coll = (PerfDataPointCollection)iterBars.next();
            if (coll.size() != 0) {
                this.setChartProperties((Chart)this.m_perf, coll, line, this.getDataSetCount());
                if (line < this.getDataSetCount() - 1) {
                    ++height;
                }
                height += this.m_interiorHeight + this.m_perf.getExteriorHeight();
            }
            ++line;
        }
        if (height == 0) {
            height = this.m_metricsLegend.getHeight();
            this.m_bNoData = true;
        }
        return height;
    }

    protected Class getDataCollectionClass() {
        return PerfDataPointCollection.class;
    }

    private int getTitleHeight(PerfDataPointCollection coll) {
        int cyText;
        int result = cyText = this.m_metricsLegend.getHeight();
        if (coll.getURL() != null) {
            result += cyText;
        }
        if (coll.getTypeString().length() > 0) {
            result += cyText;
        }
        return result;
    }

    protected Rectangle draw(ChartGraphics g) {
        Rectangle rect = null;
        if (!this.hasData()) {
            return super.draw(g);
        }
        Iterator iterLines = this.getDataSetIterator();
        int line = 0;
        while (iterLines.hasNext()) {
            PerfDataPointCollection src = (PerfDataPointCollection)iterLines.next();
            if (src.size() != 0) {
                DataPointCollection dest = this.m_perf.getDataPoints();
                dest.clear();
                dest.addAll((DataPointCollection)src);
                this.setChartProperties((Chart)this.m_perf, src, line, this.getDataSetCount());
                this.m_perf.height = this.m_interiorHeight + this.m_perf.getExteriorHeight();
                ChartGraphics g2 = new ChartGraphics((Chart)this.m_perf, g.graphics);
                this.m_perf.floor = this.m_adRangeMarks[0];
                this.m_perf.ceiling = this.m_adRangeMarks[this.m_adRangeMarks.length - 1];
                this.m_perf.calcRanges();
                this.m_perf.calc(g2.graphics);
                this.m_perf.draw(g2);
                rect = this.m_perf.getExteriorRectangle();
                this.m_perf.yOffset += this.m_perf.height;
                this.drawTitles(g, src, rect);
                g.graphics.setColor(this.xLineColor);
                g.graphics.drawLine(rect.x, this.m_perf.yOffset, rect.x + rect.width, this.m_perf.yOffset);
                this.m_perf.yOffset += this.lineWidth;
            }
            ++line;
        }
        return rect;
    }

    private void drawTitles(ChartGraphics g, PerfDataPointCollection coll, Rectangle rect) {
        String title;
        g.graphics.setColor(this.legendTextColor);
        FontMetrics metrics = g.graphics.getFontMetrics(DEFAULT_TITLE_FONT);
        int x = 5;
        int cyTitle = this.getTitleHeight(coll);
        int yTitle = rect.y + metrics.getAscent();
        String text = coll.getURL();
        if (text != null) {
            String label = this.m_destinationType + SEMICOLON;
            g.graphics.setFont(DEFAULT_TITLE_FONT);
            g.graphics.drawString(label, x, yTitle);
            g.graphics.setFont(DEFAULT_TITLE_TEXT_FONT);
            g.graphics.drawString(coll.getURL(), x + metrics.stringWidth(label), yTitle);
            yTitle += this.m_metricsLabel.getHeight();
        }
        if ((title = coll.getTypeString()).length() > 0) {
            title = title + SEMICOLON;
            g.graphics.setFont(DEFAULT_TITLE_FONT);
            g.graphics.drawString(title, x, yTitle);
            text = coll.getTypeName();
            if (text != null) {
                g.graphics.setFont(DEFAULT_TITLE_TEXT_FONT);
                g.graphics.drawString(coll.getTypeName(), x + metrics.stringWidth(title), yTitle);
            }
            yTitle += this.m_metricsLabel.getHeight();
        }
        g.graphics.setFont(DEFAULT_TITLE_FONT);
        g.graphics.drawString(CALLS, x, yTitle);
        g.graphics.setFont(DEFAULT_TITLE_TEXT_FONT);
        g.graphics.drawString(Integer.toString(coll.getRequest()), x + metrics.stringWidth(CALLS), yTitle);
    }

    private void setChartProperties(Chart chart, PerfDataPointCollection coll, int chartnum, int total) {
        if (chartnum == 0) {
            this.m_perf.showTopLabels = true;
            this.m_perf.showTopLegend = true;
            this.m_perf.showBottomLabels = false;
            this.m_perf.showBottomLegend = false;
        } else if (chartnum < this.getDataSetCount() - 1) {
            this.m_perf.showTopLabels = false;
            this.m_perf.showTopLegend = false;
            this.m_perf.showBottomLabels = false;
            this.m_perf.showBottomLegend = false;
        } else {
            this.m_perf.showTopLabels = false;
            this.m_perf.showTopLegend = false;
            this.m_perf.showBottomLabels = true;
            this.m_perf.showBottomLegend = true;
        }
        this.m_perf.topBorder = this.getTitleHeight(coll);
        this.m_perf.leftBorder = 25;
        this.m_perf.setHealthChart(false);
        this.m_perf.showMinDigits = false;
        this.m_perf.showStacked = true;
    }

    public void setFormat(MeasurementUnits units) {
        super.setFormat(units);
        this.m_perf.setValueLegend(this.m_perf.getValueLegend() + " (" + this.m_fmtUnits + ")");
    }
}

