/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition;

import org.apache.commons.validator.GenericValidator;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.composite.MeasurementNumericValueAndUnits;
import org.rhq.core.domain.measurement.util.MeasurementConversionException;
import org.rhq.core.server.MeasurementConverter;
import org.rhq.core.server.MeasurementParser;
import org.rhq.core.util.NumberUtil;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.ConditionBean;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition.ConditionBeanConverterValidator;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

class MeasurementConverterValidator
implements ConditionBeanConverterValidator {
    public static final String DOUBLE_REGEX = "[0-9,.]+";
    public static final String TYPE_ABS = "absolute";
    public static final String TYPE_PERC = "percentage";
    public static final String TYPE_CHG = "changed";
    private MeasurementDefinitionManagerLocal definitionManager = LookupUtil.getMeasurementDefinitionManager();

    public void exportProperties(Subject subject, ConditionBean fromBean, AlertCondition toCondition) {
        MeasurementDefinition definition = this.definitionManager.getMeasurementDefinition(subject, fromBean.getMetricId().intValue());
        toCondition.setMeasurementDefinition(definition);
        if (fromBean.getThresholdType().equals(TYPE_ABS)) {
            MeasurementNumericValueAndUnits valueAndUnits = MeasurementParser.parse((String)fromBean.getAbsoluteValue(), (MeasurementUnits)definition.getUnits());
            toCondition.setCategory(AlertConditionCategory.THRESHOLD);
            toCondition.setThreshold(valueAndUnits.getValue());
            toCondition.setComparator(fromBean.getAbsoluteComparator());
        } else if (fromBean.getThresholdType().equals(TYPE_PERC)) {
            MeasurementNumericValueAndUnits threshold = MeasurementParser.parse((String)fromBean.getPercentage(), (MeasurementUnits)MeasurementUnits.PERCENTAGE);
            toCondition.setCategory(AlertConditionCategory.BASELINE);
            toCondition.setThreshold(threshold.getValue());
            toCondition.setComparator(fromBean.getPercentageComparator());
            toCondition.setOption(fromBean.getBaselineOption());
        } else {
            toCondition.setCategory(AlertConditionCategory.CHANGE);
        }
        toCondition.setName(fromBean.getMetricName());
    }

    public void importProperties(Subject subject, AlertCondition fromCondition, ConditionBean toBean) {
        toBean.setMetricName(fromCondition.getName());
        toBean.setMetricId(Integer.valueOf(fromCondition.getMeasurementDefinition().getId()));
        toBean.setTrigger(this.getTriggerName());
        if (fromCondition.getCategory() == AlertConditionCategory.THRESHOLD) {
            toBean.setThresholdType(TYPE_ABS);
            MeasurementDefinition definition = fromCondition.getMeasurementDefinition();
            toBean.setMetricId(Integer.valueOf(definition.getId()));
            try {
                String formattedValue = MeasurementConverter.format((Double)fromCondition.getThreshold(), (MeasurementUnits)definition.getUnits(), (boolean)true);
                toBean.setAbsoluteValue(formattedValue);
            }
            catch (MeasurementConversionException mce) {
                toBean.setAbsoluteValue("Conversion Error");
            }
            toBean.setAbsoluteComparator(fromCondition.getComparator());
            toBean.setPercentageComparator(null);
        } else if (fromCondition.getCategory() == AlertConditionCategory.BASELINE) {
            toBean.setThresholdType(TYPE_PERC);
            toBean.setBaselineOption(fromCondition.getOption());
            Double threshold = MeasurementUnits.scaleUp((Double)fromCondition.getThreshold(), (MeasurementUnits)MeasurementUnits.PERCENTAGE);
            toBean.setPercentage(MeasurementConverter.format((Double)threshold, (MeasurementUnits)MeasurementUnits.NONE, (boolean)true));
            toBean.setAbsoluteComparator(null);
            toBean.setPercentageComparator(fromCondition.getComparator());
        } else if (fromCondition.getCategory() == AlertConditionCategory.CHANGE) {
            toBean.setThresholdType(TYPE_CHG);
            toBean.setAbsoluteComparator(null);
            toBean.setPercentageComparator(null);
        }
    }

    public boolean validate(ConditionBean bean, ActionErrors errors, int index) {
        if (bean.getMetricId() <= 0) {
            ActionMessage err = new ActionMessage("alert.config.error.NoMetricSelected");
            errors.add("condition[" + index + "].metricId", err);
            return false;
        }
        if (bean.getThresholdType().equals(TYPE_ABS)) {
            if (!GenericValidator.matchRegexp((String)bean.getAbsoluteValue(), (String)DOUBLE_REGEX)) {
                ActionMessage err = new ActionMessage("errors.double", (Object)"AbsoluteValue");
                errors.add("condition[" + index + "].absoluteValue", err);
                return false;
            }
        } else if (bean.getThresholdType().equals(TYPE_PERC)) {
            if (!GenericValidator.matchRegexp((String)bean.getPercentage(), (String)DOUBLE_REGEX)) {
                ActionMessage err = new ActionMessage("errors.double", (Object)"Percentage");
                errors.add("condition[" + index + "].percentage", err);
                return false;
            }
            double percentage = NumberUtil.stringAsNumber((String)bean.getPercentage()).doubleValue();
            if (!GenericValidator.isInRange((double)percentage, (double)0.0, (double)1000.0)) {
                ActionMessage err = new ActionMessage("errors.range", (Object)String.valueOf(percentage), (Object)String.valueOf(0.0), (Object)String.valueOf(1000.0));
                errors.add("condition[" + index + "].percentage", err);
                return false;
            }
            if (null == bean.getBaselineOption() || bean.getBaselineOption().length() == 0) {
                ActionMessage err = new ActionMessage("alert.config.error.NoBaselineOptionSelected");
                errors.add("condition[" + index + "].baselineOption", err);
                return false;
            }
        }
        return true;
    }

    public String getTriggerName() {
        return "onMeasurement";
    }
}

