/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.taglib;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.gui.common.tag.FunctionTagLibrary;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class InventoryHierarchyTag
extends TagSupport {
    private static final String SEPARATOR = " &gt; ";
    private Integer resourceId;
    private Integer groupId;
    private Integer resourceTypeId;
    private Integer parentResourceId;
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private ResourceGroupManagerLocal resourceGroupManager = LookupUtil.getResourceGroupManager();
    private ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();

    public Integer getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public Integer getParentResourceId() {
        return this.parentResourceId;
    }

    public void setParentResourceId(Integer parentResourceId) {
        this.parentResourceId = parentResourceId;
    }

    public Integer getResourceTypeId() {
        return this.resourceTypeId;
    }

    public void setResourceTypeId(Integer resourceTypeId) {
        this.resourceTypeId = resourceTypeId;
    }

    public final int doStartTag() throws JspException {
        String html;
        if (this.resourceId != null) {
            html = this.buildResourceHTML(this.resourceId);
        } else if (this.groupId != null) {
            html = this.buildGroupHTML();
        } else if (this.resourceTypeId != null) {
            html = this.buildAutoGroupHTML();
        } else {
            throw new JspException("Neither 'resourceId' nor 'groupId' attribute is present on the tag.");
        }
        try {
            this.pageContext.getOut().write(html);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    private String buildResourceHTML(Integer resourceId) {
        List ancestorResources = this.resourceManager.getResourceLineage(resourceId.intValue());
        if (ancestorResources.isEmpty()) {
            throw new IllegalStateException("The list of ancestor resources should always contain at least one resource - the resource whose lineage was requested.");
        }
        Resource parentResource = (Resource)ancestorResources.get(ancestorResources.size() - 1);
        StringBuilder html = new StringBuilder();
        for (Resource ancestorResource : ancestorResources) {
            html.append("<a href=\"").append(this.buildResourceURL(ancestorResource)).append("\">");
            html.append(ancestorResource.getName()).append("</a>");
            if (ancestorResource.getId() == parentResource.getId()) continue;
            html.append(SEPARATOR);
        }
        return html.toString();
    }

    private String buildGroupHTML() throws JspException {
        Subject subject;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        try {
            subject = RequestUtils.getSubject((HttpServletRequest)request);
        }
        catch (ServletException e) {
            throw new JspException(e.getMessage());
        }
        ResourceGroup resourceGroup = this.resourceGroupManager.getResourceGroupById(subject, this.groupId.intValue(), null);
        StringBuilder html = new StringBuilder();
        html.append("<a href=\"").append(this.buildGroupURL(resourceGroup)).append("\">");
        html.append(resourceGroup.getName()).append("</a>");
        return html.toString();
    }

    private String buildAutoGroupHTML() throws JspException {
        Subject subject;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        try {
            subject = RequestUtils.getSubject((HttpServletRequest)request);
        }
        catch (ServletException e) {
            throw new JspException(e.getMessage());
        }
        StringBuilder html = new StringBuilder();
        html.append(this.buildResourceHTML(this.parentResourceId));
        html.append(SEPARATOR);
        try {
            ResourceType resourceType = this.resourceTypeManager.getResourceTypeById(subject, this.resourceTypeId.intValue());
            html.append("<a href=\"").append(this.buildAutoGroupURL()).append("\">");
            html.append(resourceType.getName()).append("</a>");
        }
        catch (ResourceTypeNotFoundException e) {
            throw new JspException(e.getMessage());
        }
        return html.toString();
    }

    private String buildResourceURL(Resource resource) {
        String url = FunctionTagLibrary.getDefaultResourceTabURL() + "?id=" + resource.getId();
        return this.encodeURL(url);
    }

    private String buildGroupURL(ResourceGroup resourceGroup) {
        GroupCategory category = resourceGroup.getGroupCategory();
        String url = FunctionTagLibrary.getDefaultGroupTabURL() + "?category=" + category.name() + "&groupId=" + resourceGroup.getId();
        return this.encodeURL(url);
    }

    private String buildAutoGroupURL() {
        String url = FunctionTagLibrary.getDefaultAutoGroupTabURL() + "?id=" + this.parentResourceId + "&parent=" + this.parentResourceId + "&type=" + this.resourceTypeId;
        return this.encodeURL(url);
    }

    private String encodeURL(String url) {
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        return response.encodeURL(url);
    }
}

