/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.startup;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.util.LookupUtil;

public class ShutdownListener
implements NotificationListener {
    private final Log log = LogFactory.getLog(ShutdownListener.class);
    private final String RHQ_DB_TYPE_MAPPING_PROPERTY = "rhq.server.database.type-mapping";

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if ("org.jboss.system.server.stopped".equals(notification.getType())) {
            this.stopScheduler();
            this.updateServerOperationMode();
            this.stopEmbeddedDatabase();
        }
    }

    private void stopScheduler() {
        try {
            this.log.info((Object)"Shutting down the scheduler gracefully - currently running jobs will be allowed to finish...");
            LookupUtil.getSchedulerBean().shutdown(true);
            this.log.info((Object)"The scheduler has been shutdown and all jobs are done.");
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.warn((Object)"Failed to shutdown the scheduler", t);
            }
            this.log.warn((Object)("Failed to shutdown the scheduler: " + t.getMessage()));
        }
    }

    private void updateServerOperationMode() {
        try {
            Server server = LookupUtil.getServerManager().getServer();
            if (Server.OperationMode.MAINTENANCE != server.getOperationMode()) {
                LookupUtil.getCloudManager().updateServerMode(new Integer[]{server.getId()}, Server.OperationMode.DOWN);
            }
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.warn((Object)"Could not update this server's OperationMode to DOWN in the database", t);
            }
            this.log.warn((Object)("Could not update this server's OperationMode to DOWN in the database: " + t.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopEmbeddedDatabase() {
        if (!this.isEmbedded()) {
            return;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            DataSource ds = LookupUtil.getDataSource();
            connection = ds.getConnection();
            statement = connection.createStatement();
            statement.execute("shutdown");
            this.log.info((Object)"Embedded database closed cleanly");
        }
        catch (SQLException sqle) {
            block8: {
                block7: {
                    try {
                        if (sqle.getMessage().toLowerCase().indexOf("database is already closed") == -1) break block7;
                        this.log.warn((Object)"Database is already shut down, can not perform graceful service shutdown");
                    }
                    catch (Throwable throwable) {
                        JDBCUtil.safeClose((Connection)connection, statement, null);
                        throw throwable;
                    }
                    JDBCUtil.safeClose((Connection)connection, (Statement)statement, null);
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.warn((Object)"Could not shut down the embedded database cleanly", (Throwable)sqle);
                    break block8;
                }
                this.log.warn((Object)("Could not shut down the embedded database cleanly: " + sqle.getMessage()));
            }
            JDBCUtil.safeClose((Connection)connection, (Statement)statement, null);
        }
        JDBCUtil.safeClose((Connection)connection, (Statement)statement, null);
    }

    private boolean isEmbedded() {
        String identity = System.getProperty("rhq.server.database.type-mapping", "");
        if (identity.equals("")) {
            this.log.error((Object)"Could not determine datatype base; is the rhq.server.database.type-mapping property set in rhq-server.properties?");
        }
        return identity.toLowerCase().indexOf("h2") != -1;
    }
}

