/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.ha;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.PartitionEvent;
import org.rhq.core.domain.cloud.PartitionEventType;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.enterprise.gui.common.converter.SelectItemUtils;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.ha.ListPartitionEventsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.cloud.PartitionEventManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListPartitionEventsUIBean
extends PagedDataTableUIBean {
    private static final Log log = LogFactory.getLog(ListPartitionEventsUIBean.class);
    public static final String MANAGED_BEAN_NAME = "ListPartitionEventsUIBean";
    private PartitionEventManagerLocal partitionEventManager = LookupUtil.getPartitionEventManager();
    private String typeFilter;
    private String detailsFilter;
    private String executionStatusFilter;
    private SelectItem[] typeSelectItems;
    private SelectItem[] executionStatusSelectItems;

    public String getTypeFilter() {
        if (this.typeFilter == null) {
            this.typeFilter = SelectItemUtils.getSelectItemFilter((String)"partitionEventsForm:typeFilter");
        }
        return SelectItemUtils.cleanse((String)this.typeFilter);
    }

    public void setTypeFilter(String typeFilter) {
        this.typeFilter = typeFilter;
    }

    public PartitionEventType getPartitionEventType() {
        String typeName = this.getTypeFilter();
        if (typeName != null) {
            return Enum.valueOf(PartitionEventType.class, typeName);
        }
        return null;
    }

    public String getDetailsFilter() {
        return this.detailsFilter;
    }

    public void setDetailsFilter(String detailsFilter) {
        this.detailsFilter = detailsFilter;
    }

    public String getExecutionStatusFilter() {
        if (this.executionStatusFilter == null) {
            this.executionStatusFilter = SelectItemUtils.getSelectItemFilter((String)"partitionEventsForm:executionStatusFilter");
        }
        return SelectItemUtils.cleanse((String)this.executionStatusFilter);
    }

    public void setExecutionStatusFilter(String executionStatusFilter) {
        this.executionStatusFilter = executionStatusFilter;
    }

    public PartitionEvent.ExecutionStatus getExecutionStatus() {
        String executionStatusName = this.getExecutionStatusFilter();
        if (executionStatusName != null) {
            return Enum.valueOf(PartitionEvent.ExecutionStatus.class, executionStatusName);
        }
        return null;
    }

    public SelectItem[] getTypeSelectItems() {
        if (this.typeSelectItems == null) {
            this.typeSelectItems = SelectItemUtils.convertFromEnum(PartitionEventType.class, (boolean)true);
        }
        return this.typeSelectItems;
    }

    public SelectItem[] getExecutionStatusSelectItems() {
        if (this.executionStatusSelectItems == null) {
            this.executionStatusSelectItems = SelectItemUtils.convertFromEnum(PartitionEvent.ExecutionStatus.class, (boolean)true);
        }
        return this.executionStatusSelectItems;
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListPartitionEventsDataModel(this, PageControlView.ListPartitionEventsView, MANAGED_BEAN_NAME, null);
        }
        return this.dataModel;
    }

    public String removeSelectedEvents() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedEvents = this.getSelectedAlerts();
        Integer[] eventIds = StringUtility.getIntegerArray((String[])selectedEvents);
        try {
            this.partitionEventManager.deletePartitionEvents(subject, eventIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + eventIds.length + " events."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete selected events.", (Throwable)e);
        }
        return "success";
    }

    public String purgeAllEvents() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        try {
            int numDeleted = this.partitionEventManager.purgeAllEvents(subject);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + numDeleted + " events"));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to purge events", (Throwable)e);
            log.error((Object)"Failed to purge events", (Throwable)e);
        }
        return "success";
    }

    public String repartition() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        try {
            this.partitionEventManager.cloudPartitionEventRequest(subject, PartitionEventType.ADMIN_INITIATED_PARTITION, "");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Forced repartition / redistribution failed", (Throwable)e);
            log.error((Object)"Forced repartition / redistribution failed", (Throwable)e);
        }
        return "success";
    }

    private String[] getSelectedAlerts() {
        return FacesContextUtility.getRequest().getParameterValues("selectedEvents");
    }

    static /* synthetic */ PartitionEventManagerLocal access$100(ListPartitionEventsUIBean x0) {
        return x0.partitionEventManager;
    }
}

