/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.time.converter;

import java.text.DecimalFormat;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

public class LongDurationConverter
implements Converter {
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final DecimalFormat twoDigitFormatter = new DecimalFormat("00");

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        long millis = 0L;
        if (value != null) {
            String[] parts = value.split(":");
            millis += (long)Integer.parseInt(parts[0]) * 3600000L;
            millis += (long)Integer.parseInt(parts[1]) * 60000L;
            millis += (long)Integer.parseInt(parts[2]) * 1000L;
        }
        return millis;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return "0";
        }
        long millis = 0L;
        if (value instanceof Long) {
            millis = (Long)value;
        } else if (value instanceof Double) {
            millis = ((Double)value).longValue();
        } else {
            throw new IllegalArgumentException("The " + LongDurationConverter.class.getSimpleName() + " converter does not support rendering objects of type " + value.getClass().getSimpleName());
        }
        StringBuilder buf = new StringBuilder();
        int days = (int)(millis / 86400000L);
        millis %= 86400000L;
        if (days > 0) {
            buf.append(days + " day");
            if (days != 1) {
                buf.append("s");
            }
        }
        int hours = (int)(millis / 3600000L);
        millis %= 3600000L;
        if (hours > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(hours + " hour");
            if (hours != 1) {
                buf.append("s");
            }
        }
        int mins = (int)(millis / 60000L);
        millis %= 60000L;
        if (mins > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(mins + " minute");
            if (mins != 1) {
                buf.append("s");
            }
        }
        return buf.toString();
    }
}

