/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIData;
import javax.faces.model.DataModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.DeployPackagesUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class DeployPackagesUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "DeployPackagesUIBean";
    private int[] selectedPackageIds;
    private UIData packagesToDeployData;
    private String notes;
    private final Log log = LogFactory.getLog(this.getClass());

    public String deployPackages() {
        if (this.notes != null && this.notes.length() > 512) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Package notes must be 512 characters or less.");
            return null;
        }
        HttpServletRequest request = FacesContextUtility.getRequest();
        HttpSession session = request.getSession();
        int[] packageIds = (int[])session.getAttribute("selectedPackages");
        ContentUIManagerLocal contentUIManager = LookupUtil.getContentUIManager();
        int[] packagesVersionsIdsToDeploy = new int[packageIds.length];
        for (int iterator = 0; iterator < packageIds.length; ++iterator) {
            PackageVersion packageVersion = contentUIManager.getPackageVersion(packageIds[iterator]);
            packagesVersionsIdsToDeploy[iterator] = packageVersion.getId();
        }
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Resource resource = EnterpriseFacesContextUtility.getResource();
        try {
            ContentManagerLocal contentManager = LookupUtil.getContentManager();
            contentManager.deployPackagesWithNote(subject, new int[]{resource.getId()}, packagesVersionsIdsToDeploy, this.notes);
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Could not send deploy request to agent", (Throwable)e);
        }
        return "successOrFailure";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new DeployPackagesDataModel(this, PageControlView.PackagesToDeployList, MANAGED_BEAN_NAME, null);
        }
        return this.dataModel;
    }

    public UIData getPackagesToDeployData() {
        return this.packagesToDeployData;
    }

    public void setPackagesToDeployData(UIData packagesToDeployData) {
        this.packagesToDeployData = packagesToDeployData;
    }

    public String getNotes() {
        if (this.notes == null) {
            HttpServletRequest request = FacesContextUtility.getRequest();
            HttpSession session = request.getSession();
            int[] packageIds = (int[])session.getAttribute("selectedPackages");
            ContentUIManagerLocal contentUIManager = LookupUtil.getContentUIManager();
            StringBuffer sb = new StringBuffer("Packages: ");
            int counter = 0;
            for (int pkgId : packageIds) {
                PackageVersion packageVersion = contentUIManager.getPackageVersion(pkgId);
                Package generalPackage = packageVersion.getGeneralPackage();
                String version = packageVersion.getDisplayVersion() != null ? packageVersion.getDisplayVersion() : packageVersion.getVersion();
                String packageToAppend = generalPackage.getName() + " " + version;
                if (sb.toString().length() + packageToAppend.length() > 508) {
                    if (counter != packageIds.length - 1) {
                        sb.append("...");
                        break;
                    }
                    if (sb.toString().length() + packageToAppend.length() <= 511) {
                        sb.append(packageToAppend);
                        break;
                    }
                    sb.append("...");
                    break;
                }
                sb.append(packageToAppend);
                if (counter++ >= packageIds.length - 1) continue;
                sb.append(", ");
            }
            this.notes = sb.toString();
        }
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public int[] getSelectedPackageIds() {
        if (this.selectedPackageIds == null) {
            this.selectedPackageIds = (int[])FacesContextUtility.getRequest().getSession().getAttribute("selectedPackages");
        }
        return this.selectedPackageIds;
    }
}

