/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.browse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.InventorySummary;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.ResourceBossLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class InventorySummaryUIBean {
    protected final Log log = LogFactory.getLog(InventorySummaryUIBean.class);
    private boolean showCounts = false;
    private int platformCount;
    private int serverCount;
    private int serviceCount;
    private int compatibleCount;
    private int mixedCount;
    private int groupDefinitionCount;
    private Subject subject;

    public InventorySummaryUIBean() {
        try {
            this.subject = EnterpriseFacesContextUtility.getSubject();
            this.load();
        }
        catch (Throwable t) {
            this.log.error((Object)("InventorySummaryUIBean constructor experienced an error: " + t.getMessage()));
        }
    }

    private void load() {
        try {
            ResourceBossLocal resourceBoss = LookupUtil.getResourceBoss();
            InventorySummary summary = resourceBoss.getInventorySummary(this.subject);
            this.loadFromSummary(summary);
            this.showCounts = true;
        }
        catch (Throwable t) {
            this.log.error((Object)("InventorySummaryUIBean loader experienced an error: " + t.getMessage()));
            this.showCounts = false;
        }
    }

    private void loadFromSummary(InventorySummary summary) {
        this.platformCount = summary.getPlatformCount();
        this.serverCount = summary.getServerCount();
        this.serviceCount = summary.getServiceCount();
        this.compatibleCount = summary.getCompatibleGroupCount();
        this.mixedCount = summary.getMixedGroupCount();
        this.groupDefinitionCount = summary.getGroupDefinitionCount();
    }

    public String getResourceCount() {
        return this.format(this.platformCount + this.serverCount + this.serviceCount);
    }

    public String getPlatformCount() {
        return this.format(this.platformCount);
    }

    public String getServerCount() {
        return this.format(this.serverCount);
    }

    public String getServiceCount() {
        return this.format(this.serviceCount);
    }

    public String getGroupCount() {
        return this.format(this.compatibleCount + this.mixedCount);
    }

    public String getCompatibleCount() {
        return this.format(this.compatibleCount);
    }

    public String getMixedCount() {
        return this.format(this.mixedCount);
    }

    public String getGroupDefinitionCount() {
        return this.format(this.groupDefinitionCount);
    }

    private String format(int count) {
        if (this.showCounts) {
            return "(" + count + ")";
        }
        return "";
    }
}

