/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.user;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.enterprise.gui.admin.user.NewForm;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RegisterAction
extends BaseAction {
    SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
    SystemManagerLocal systemManager = LookupUtil.getSystemManager();
    LdapGroupManagerLocal ldapManager = LookupUtil.getLdapGroupManager();

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog((String)RegisterAction.class.getName());
        NewForm userForm = (NewForm)form;
        HttpSession session = request.getSession(false);
        ActionForward forward = this.checkSubmit(request, mapping, form);
        if (forward != null) {
            return forward;
        }
        WebUser webUser = SessionUtils.getWebUser((HttpSession)session);
        Subject newSubject = new Subject();
        newSubject.setName(webUser.getUsername());
        newSubject.setFirstName(userForm.getFirstName());
        newSubject.setLastName(userForm.getLastName());
        newSubject.setDepartment(userForm.getDepartment());
        newSubject.setEmailAddress(userForm.getEmailAddress());
        newSubject.setPhoneNumber(userForm.getPhoneNumber());
        newSubject.setSmsAddress(userForm.getSmsAddress());
        newSubject.setFactive(true);
        newSubject.setFsystem(false);
        Configuration userPrefs = (Configuration)this.getServlet().getServletContext().getAttribute("userPrefs");
        newSubject.setUserConfiguration(userPrefs);
        String password = (String)session.getAttribute("password");
        session.removeAttribute("password");
        Subject superuser = this.subjectManager.getOverlord();
        log.trace((Object)("registering new LDAP-authenticated subject [" + newSubject.getName() + "]"));
        this.subjectManager.createSubject(superuser, newSubject);
        this.subjectManager.logout(RequestUtils.getSessionId((HttpServletRequest)request).intValue());
        newSubject = this.subjectManager.login(newSubject.getName(), password);
        webUser = new WebUser(newSubject);
        SessionUtils.setWebUser((HttpSession)session, (WebUser)webUser);
        session.setAttribute("useroperations", new HashMap());
        HashMap<String, Integer> parms = new HashMap<String, Integer>(1);
        parms.put("u", newSubject.getId());
        return this.returnSuccess(request, mapping, parms, false);
    }
}

