/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert.common;

import javax.faces.application.FacesMessage;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.EnterpriseFacesContextUIBean;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderInfo;
import org.rhq.enterprise.server.plugin.pc.alert.CustomAlertSenderBackingBean;

public class CustomContentUIBean
extends EnterpriseFacesContextUIBean {
    private Integer alertNotificationId;
    private AlertNotificationManagerLocal alertNotificationManager;
    private String contentUrl;
    private CustomAlertSenderBackingBean customBackingBean;

    public String getContentUrl() {
        return this.contentUrl;
    }

    public void init() {
        if (this.alertNotificationId == null) {
            return;
        }
        AlertNotification activeNotification = this.alertNotificationManager.getAlertNotification(this.getSubject(), this.alertNotificationId.intValue());
        if (activeNotification == null) {
            return;
        }
        String senderName = activeNotification.getSenderName();
        AlertSenderInfo info = this.alertNotificationManager.getAlertInfoForSender(senderName);
        if (info != null && info.getUiSnippetUrl() != null) {
            this.contentUrl = info.getUiSnippetUrl().toString();
        }
        String backingBeanName = this.alertNotificationManager.getBackingBeanNameForSender(senderName);
        this.customBackingBean = this.alertNotificationManager.getBackingBeanForSender(senderName, this.alertNotificationId);
        if (backingBeanName != null && this.customBackingBean != null) {
            this.customBackingBean.setWebUser(this.getSubject());
            this.customBackingBean.setContext(FacesContextUtility.getRequiredRequestParameter((String)"context"));
            this.customBackingBean.setContextId(FacesContextUtility.getRequiredRequestParameter((String)"contextId"));
            this.customBackingBean.setContextSubId(FacesContextUtility.getOptionalRequestParameter((String)"contextSubId", (String)null));
            this.customBackingBean.setAlertNotificationId(this.alertNotificationId);
            this.customBackingBean.loadView();
            this.outjectBean(backingBeanName, this.customBackingBean);
        }
    }

    private void outjectBean(String name, CustomAlertSenderBackingBean bean) {
    }

    public String saveConfiguration() {
        try {
            this.customBackingBean.saveView();
            int notificationId = this.customBackingBean.getAlertNotificationId();
            AlertNotification notification = this.alertNotificationManager.getAlertNotification(this.getSubject(), notificationId);
            if (this.customBackingBean.getExtraParameters() != null) {
                notification.setExtraConfiguration(this.customBackingBean.getExtraParameters());
            } else {
                notification.setExtraConfiguration(null);
            }
            int alertDefinitionId = Integer.parseInt(this.customBackingBean.getContextId());
            this.alertNotificationManager.updateAlertNotification(this.getSubject(), alertDefinitionId, notification);
        }
        catch (Throwable t) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to save alert notification", (Throwable)t);
        }
        return "success";
    }
}

