/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import java.util.ArrayList;
import javax.faces.application.FacesMessage;
import javax.faces.model.SelectItem;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.criteria.SubjectCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.RepoException;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class CreateRepoUIBean {
    private Repo newRepo;

    public CreateRepoUIBean() {
        this.initNewRepo();
    }

    public Repo getRepo() {
        return this.newRepo;
    }

    public void setRepo(Repo newRepo) {
        this.newRepo = newRepo;
    }

    public SelectItem[] getAvailableOwners() {
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        SubjectCriteria c = new SubjectCriteria();
        c.addFilterFsystem(Boolean.valueOf(false));
        c.addSortName(PageOrdering.ASC);
        PageList subjects = subjectManager.findSubjectsByCriteria(subject, c);
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(subjects.size());
        items.add(new SelectItem(null, "--None--"));
        for (Subject s : subjects) {
            SelectItem item = new SelectItem((Object)s.getName(), s.getName());
            items.add(item);
        }
        return items.toArray(new SelectItem[items.size()]);
    }

    public boolean isRepositoryManager() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        return LookupUtil.getAuthorizationManager().hasGlobalPermission(subject, Permission.MANAGE_REPOSITORIES);
    }

    public String save() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        RepoManagerLocal manager = LookupUtil.getRepoManagerLocal();
        try {
            this.updateRepoOwner(subject);
            this.newRepo.setCandidate(false);
            Repo created = manager.createRepo(subject, this.newRepo);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Saved [" + created.getName() + "] with the ID of [" + created.getId() + "]"));
        }
        catch (RepoException ce) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Error: " + ce.getMessage()));
            return "failed";
        }
        this.initNewRepo();
        return "save";
    }

    public String cancel() {
        this.initNewRepo();
        return "cancel";
    }

    private void updateRepoOwner(Subject loggedInSubject) {
        if (this.newRepo.getOwner().getName() == null) {
            this.newRepo.setOwner(null);
        } else if (this.newRepo.getOwner().getName().equals(loggedInSubject.getName())) {
            this.newRepo.setOwner(loggedInSubject);
        } else {
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            Subject s = subjectManager.getSubjectByName(this.newRepo.getOwner().getName());
            this.newRepo.setOwner(s);
        }
    }

    private void initNewRepo() {
        this.newRepo = new Repo();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        Subject currenUserCopy = subjectManager.getSubjectById(EnterpriseFacesContextUtility.getSubject().getId());
        this.newRepo.setOwner(currenUserCopy);
    }
}

