/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.RepoContentSourcesUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RepoContentSourcesUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "RepoContentSourcesUIBean";

    public String associateWithContentProviders() {
        return "associateWithContentProviders";
    }

    public String disassociateWithContentProviders() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedRepoContentProviders();
        int repoId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        int[] contentSourceIds = this.getIntegerArray(selected);
        if (contentSourceIds != null && contentSourceIds.length > 0) {
            try {
                RepoManagerLocal manager = LookupUtil.getRepoManagerLocal();
                manager.removeContentSourcesFromRepo(subject, repoId, contentSourceIds);
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Disassociated [" + contentSourceIds.length + "] content sources from repository"));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to disassociate one or more content sources from repository", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new RepoContentSourcesDataModel(this, PageControlView.RepoContentSourcesList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedRepoContentProviders() {
        return FacesContextUtility.getRequest().getParameterValues("selectedRepoContentProviders");
    }

    private int[] getIntegerArray(String[] input) {
        if (input == null) {
            return new int[0];
        }
        int[] output = new int[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

