/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import java.util.ArrayList;
import javax.faces.application.FacesMessage;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.resource.CreateResourceHistory;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.inventory.resource.CreateNewConfigurationChildResourceUIBean;
import org.rhq.enterprise.gui.inventory.resource.CreateNewPackageChildResourceUIBean;
import org.rhq.enterprise.gui.inventory.resource.DetermineChildResourceCreationTypeUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.util.LookupUtil;

public class DetermineChildResourceCreationTypeUIBean {
    private static final String OUTCOME_NO_TYPE = "noTypeSelected";
    private static final String OUTCOME_ARTIFACT = "artifact";
    private static final String OUTCOME_CONFIGURATION_MULTIPLE_TEMPLATES = "configuration-multipleTemplates";
    private static final String OUTCOME_CONFIGURATION_SINGLE_TEMPLATE = "configuration-singleTemplate";
    private CreateResourceHistory retryCreateItem;

    public String determineCreationType() {
        ResourceType resourceType;
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        HttpServletRequest request = FacesContextUtility.getRequest();
        String sRetryCreateItemId = request.getParameter("retryCreateItemId");
        if (sRetryCreateItemId != null) {
            ResourceFactoryManagerLocal resourceFactoryManager = LookupUtil.getResourceFactoryManager();
            int retryCreateItemId = Integer.parseInt(sRetryCreateItemId);
            this.retryCreateItem = resourceFactoryManager.getCreateHistoryItem(retryCreateItemId);
        }
        if (this.retryCreateItem != null) {
            resourceType = this.retryCreateItem.getResourceType();
            FacesContextUtility.getFacesContext().getExternalContext().getRequestMap().put("type", resourceType.getId());
            switch (1.$SwitchMap$org$rhq$core$domain$resource$ResourceCreationDataType[resourceType.getCreationDataType().ordinal()]) {
                case 1: {
                    CreateNewPackageChildResourceUIBean createPackageBean = (CreateNewPackageChildResourceUIBean)FacesContextUtility.getManagedBean(CreateNewPackageChildResourceUIBean.class);
                    createPackageBean.setResourceType(this.retryCreateItem.getResourceType());
                    createPackageBean.setConfiguration(this.retryCreateItem.getConfiguration());
                    break;
                }
                case 2: {
                    CreateNewConfigurationChildResourceUIBean createConfigBean = (CreateNewConfigurationChildResourceUIBean)FacesContextUtility.getManagedBean(CreateNewConfigurationChildResourceUIBean.class);
                    createConfigBean.setResourceName(this.retryCreateItem.getCreatedResourceName());
                    createConfigBean.setResourceType(this.retryCreateItem.getResourceType());
                    createConfigBean.setConfiguration(this.retryCreateItem.getConfiguration());
                    break;
                }
            }
        } else {
            ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
            int resourceTypeId = EnterpriseFacesContextUtility.getResourceType().getId();
            try {
                resourceType = resourceTypeManager.getResourceTypeById(subject, resourceTypeId);
            }
            catch (ResourceTypeNotFoundException e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Could not retrieve resource type for resource type id: " + resourceTypeId));
                return OUTCOME_NO_TYPE;
            }
        }
        String outcome = OUTCOME_NO_TYPE;
        switch (1.$SwitchMap$org$rhq$core$domain$resource$ResourceCreationDataType[resourceType.getCreationDataType().ordinal()]) {
            case 1: {
                outcome = OUTCOME_ARTIFACT;
                break;
            }
            case 2: {
                ConfigurationDefinition configurationDefinition = this.lookupConfigurationDefinition(resourceType.getId());
                outcome = configurationDefinition.getTemplates().size() > 1 ? OUTCOME_CONFIGURATION_MULTIPLE_TEMPLATES : OUTCOME_CONFIGURATION_SINGLE_TEMPLATE;
                break;
            }
        }
        return outcome;
    }

    public SelectItem[] getFailedCreateHistory() {
        Subject user = EnterpriseFacesContextUtility.getSubject();
        Resource parentResource = EnterpriseFacesContextUtility.getResource();
        ResourceFactoryManagerLocal resourceFactoryManager = LookupUtil.getResourceFactoryManager();
        PageControl pageControl = new PageControl(0, 1000);
        PageList pageList = resourceFactoryManager.findCreateChildResourceHistory(user, parentResource.getId(), null, null, pageControl);
        ArrayList<SelectItem> selectItemsList = new ArrayList<SelectItem>();
        for (CreateResourceHistory history : pageList) {
            if (history.getStatus() != CreateResourceStatus.FAILURE && history.getStatus() != CreateResourceStatus.TIMED_OUT) continue;
            selectItemsList.add(new SelectItem((Object)history, history.getCreatedResourceName()));
        }
        SelectItem[] items = selectItemsList.toArray(new SelectItem[selectItemsList.size()]);
        return items;
    }

    private ConfigurationDefinition lookupConfigurationDefinition(int resourceTypeId) {
        Subject user = EnterpriseFacesContextUtility.getSubject();
        ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
        ConfigurationDefinition configurationDefinition = configurationManager.getResourceConfigurationDefinitionWithTemplatesForResourceType(user, resourceTypeId);
        return configurationDefinition;
    }

    public CreateResourceHistory getRetryCreateItem() {
        return this.retryCreateItem;
    }

    public void setRetryCreateItem(CreateResourceHistory retryCreateItem) {
        this.retryCreateItem = retryCreateItem;
    }
}

