/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.plugin;

import javax.faces.application.FacesMessage;
import org.rhq.core.clientapi.agent.metadata.ConfigurationMetadataParser;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationDescriptor;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.plugin.PluginDeploymentType;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

public abstract class AbstractPluginConfigurationUIBean {
    protected final ServerPluginsLocal serverPluginsBean = LookupUtil.getServerPlugins();
    private ServerPlugin plugin;
    private ConfigurationDefinition pluginConfigurationDefinition;
    private ConfigurationDefinition scheduledJobsDefinition;

    public ServerPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(ServerPlugin plugin) {
        this.plugin = plugin;
    }

    public ConfigurationDefinition getPluginConfigurationDefinition() {
        return this.pluginConfigurationDefinition;
    }

    public ConfigurationDefinition getScheduledJobsDefinition() {
        return this.scheduledJobsDefinition;
    }

    public boolean isEditable() {
        return this.plugin != null && (this.plugin.getPluginConfiguration() != null || this.plugin.getScheduledJobsConfiguration() != null);
    }

    protected void checkPermission() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        if (!LookupUtil.getAuthorizationManager().hasGlobalPermission(subject, Permission.MANAGE_SETTINGS)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have the proper permissions to view or manage plugins");
        }
    }

    protected void lookupConfigDefinitions() {
        if (this.plugin.getDeployment() == PluginDeploymentType.SERVER) {
            PluginKey pluginKey = new PluginKey(this.plugin);
            try {
                ServerPluginDescriptorType descriptor = this.serverPluginsBean.getServerPluginDescriptor(pluginKey);
                this.pluginConfigurationDefinition = ConfigurationMetadataParser.parse((String)("pc:" + pluginKey.getPluginName()), (ConfigurationDescriptor)descriptor.getPluginConfiguration());
                this.scheduledJobsDefinition = ConfigurationMetadataParser.parse((String)("jobs:" + pluginKey.getPluginName()), (ConfigurationDescriptor)descriptor.getScheduledJobs());
            }
            catch (Exception e) {
                String err = "Cannot determine what the plugin configuration or scheduled jobs configuration looks like";
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)err, (Throwable)e);
            }
        }
    }
}

