/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.group;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.inventory.group.ViewGroupConnectionPropertyHistoryUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ViewGroupConnectionPropertyHistoryUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ViewGroupConnectionPropertyHistoryUIBean";
    public static final String VIEW_ID = "/rhq/group/inventory/connectionHistory.xhtml";
    private ResourceGroup resourceGroup;
    private ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();

    public String begin() {
        return "viewHistory";
    }

    public String deleteSelectedUpdates() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ResourceGroup resourceGroup = EnterpriseFacesContextUtility.getResourceGroup();
        String[] selectedUpdateStringIds = FacesContextUtility.getRequest().getParameterValues("selectedUpdates");
        Integer[] selectedUpdateIds = StringUtility.getIntegerArray((String[])selectedUpdateStringIds);
        try {
            int deleteCount = this.configurationManager.deleteGroupPluginConfigurationUpdates(subject, Integer.valueOf(resourceGroup.getId()), selectedUpdateIds);
            if (deleteCount == selectedUpdateIds.length) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + selectedUpdateIds.length + " group connection property updates."));
            } else {
                int failedToDelete = selectedUpdateIds.length - deleteCount;
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Unknown error deleting " + failedToDelete + " group connection property updates."));
            }
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete selected group connection property updates.", (Throwable)e);
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListGroupConnectionPropertyUpdateHistoryDataModel(this, PageControlView.GroupConnectionPropertyUpdateHistory, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    static /* synthetic */ ResourceGroup access$000(ViewGroupConnectionPropertyHistoryUIBean x0) {
        return x0.resourceGroup;
    }

    static /* synthetic */ ResourceGroup access$002(ViewGroupConnectionPropertyHistoryUIBean x0, ResourceGroup x1) {
        x0.resourceGroup = x1;
        return x0.resourceGroup;
    }
}

