/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.legacy.BaseFilter;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.auth.SessionTimeoutException;
import org.rhq.enterprise.server.util.LookupUtil;

public final class AuthenticationFilter
extends BaseFilter {
    private static Log log = LogFactory.getLog(AuthenticationFilter.class);

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean serverInitialized;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpServletRequest request = (HttpServletRequest)req;
        try {
            serverInitialized = LookupUtil.getStartupLocal().isInitialized();
        }
        catch (Throwable t) {
            serverInitialized = false;
        }
        if (!serverInitialized) {
            response.setHeader("Retry-After", "30");
            response.sendError(503, "Server is not ready - still booting up");
            return;
        }
        HttpSession session = request.getSession();
        WebUser webUser = SessionUtils.getWebUser((HttpSession)session);
        if (webUser != null) {
            try {
                Subject subject = webUser.getSubject();
                if (subject == null) {
                    throw new SessionNotFoundException("Web user not associated with a subject");
                }
                SessionManager.getInstance().getSubject(subject.getSessionId().intValue());
            }
            catch (SessionNotFoundException snfe) {
                session.removeAttribute("u");
                SessionUtils.setWebUser((HttpSession)session, null);
                webUser = null;
            }
            catch (SessionTimeoutException ste) {
                session.removeAttribute("u");
                SessionUtils.setWebUser((HttpSession)session, null);
                webUser = null;
            }
        }
        if (webUser == null) {
            String path = request.getServletPath();
            if ("/Login.do".equals(path) || "/j_security_check.do".equals(path)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                Map parameters = request.getParameterMap();
                if (!parameters.isEmpty()) {
                    HashMap<String, String> newMap = new HashMap<String, String>();
                    for (Object keyObj : parameters.keySet()) {
                        String key = (String)keyObj;
                        newMap.put(key, request.getParameter(key));
                    }
                    session.setAttribute("forwardParams", newMap);
                }
                session.setAttribute("forwardURL", (Object)path);
                response.setStatus(401);
                response.sendRedirect(request.getContextPath() + "/Login.do");
            }
        } else {
            try {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (IOException e) {
                log.warn((Object)("Caught IO Exception from client " + request.getRemoteAddr() + ": " + e.getMessage()));
            }
        }
    }
}

