/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.rhq.enterprise.gui.legacy.action.BaseValidatorForm;

public class CalendarForm
extends BaseValidatorForm {
    private Integer startMonth;
    private Integer startDay;
    private Integer startYear;
    private String startHour;
    private String startMin;
    private String startAmPm;
    private boolean wantEndDate;
    private Integer endMonth;
    private Integer endDay;
    private Integer endYear;
    private String endHour;
    private String endMin;
    private String endAmPm;
    public static final String AM = "am";
    public static final String PM = "pm";

    public Date getEndDate() {
        if (!this.getWantEndDate()) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, this.endYear);
        cal.set(2, this.endMonth);
        cal.set(5, this.endDay);
        try {
            cal.set(11, this.calcHour(this.endHour, this.endAmPm));
            cal.set(12, Integer.parseInt(this.endMin));
            cal.set(13, 0);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return cal.getTime();
    }

    public void populateEndDate(Date d, Locale userLocale) {
        GregorianCalendar cal = new GregorianCalendar(userLocale);
        cal.setTime(d);
        this.endYear = cal.get(1);
        this.endMonth = cal.get(2);
        this.endDay = cal.get(5);
        this.endMin = this.fmtTime(cal.get(12));
        int tmpEndHour = cal.get(10);
        if (cal.get(10) == 0) {
            tmpEndHour = 12;
        }
        this.endAmPm = cal.get(9) == 1 ? PM : AM;
        this.endHour = this.fmtTime(tmpEndHour);
    }

    public Date getStartDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, this.startYear);
        cal.set(2, this.startMonth);
        cal.set(5, this.startDay);
        try {
            cal.set(11, this.calcHour(this.startHour, this.startAmPm));
            cal.set(12, Integer.parseInt(this.startMin));
            cal.set(13, 0);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return cal.getTime();
    }

    protected int calcHour(String hour, String ampm) throws NumberFormatException {
        int tmpStart = Integer.parseInt(hour);
        if (tmpStart == 0 || tmpStart > 12 && tmpStart <= 23) {
            return tmpStart;
        }
        if (PM.equals(ampm)) {
            if (tmpStart == 12) {
                return tmpStart;
            }
            return tmpStart + 12;
        }
        if (tmpStart == 12) {
            tmpStart -= 12;
        }
        return tmpStart;
    }

    public void populateStartDate(Date startDate, Locale userLocale) {
        GregorianCalendar cal = new GregorianCalendar(userLocale);
        cal.setTime(startDate);
        this.startYear = cal.get(1);
        this.startMonth = cal.get(2);
        this.startDay = cal.get(5);
        this.startMin = this.fmtTime(cal.get(12));
        int tmpStartHour = cal.get(10);
        if (cal.get(10) == 0) {
            tmpStartHour = 12;
        }
        this.startAmPm = cal.get(9) == 1 ? PM : AM;
        this.startHour = this.fmtTime(tmpStartHour);
    }

    private String fmtTime(int s) {
        if (s < 10) {
            return "0" + s;
        }
        return String.valueOf(s);
    }

    protected Calendar getInitStartTime() {
        Calendar cal = Calendar.getInstance();
        return cal;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        Calendar cal = this.getInitStartTime();
        this.startMin = this.fmtTime(cal.get(12));
        int hr = cal.get(10);
        if (hr == 0) {
            hr = 12;
        }
        this.startHour = this.fmtTime(hr);
        this.startAmPm = cal.get(9) == 0 ? AM : PM;
        this.startDay = cal.get(7);
        this.startMonth = cal.get(2);
        this.startYear = 1;
        this.wantEndDate = false;
        this.endHour = this.startHour;
        this.endMin = this.startMin;
        this.endMonth = 0;
        this.endDay = 1;
        this.endYear = cal.get(1);
        super.reset(mapping, request);
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        if (!this.shouldValidate(mapping, request)) {
            return null;
        }
        ActionErrors errs = super.validate(mapping, request);
        if (errs == null) {
            errs = new ActionErrors();
        }
        if (this.shouldValidateDateRange()) {
            this.validateDateRange(mapping, request, errs);
        }
        return errs.isEmpty() ? null : errs;
    }

    protected boolean shouldValidateDateRange() {
        return true;
    }

    protected final void validateDateRange(ActionMapping mapping, HttpServletRequest request, ActionErrors errs) {
        try {
            int tmph = Integer.parseInt(this.startHour);
            if (tmph < 0 || tmph > 12) {
                errs.add("startHour", new ActionMessage("errors.range", (Object)this.startHour, (Object)1, (Object)12));
            }
        }
        catch (NumberFormatException nfe) {
            errs.add("startHour", new ActionMessage("errors.invalid.StartHour", (Object)this.startHour));
        }
        try {
            int tmpmin = Integer.parseInt(this.startMin);
            if (tmpmin > 59 || tmpmin < 0) {
                errs.add("startMin", new ActionMessage("errors.range", (Object)this.startMin, (Object)0, (Object)59));
            }
        }
        catch (NumberFormatException nfe) {
            errs.add("startMin", new ActionMessage("errors.invalid.StartMin", (Object)this.startMin));
        }
        try {
            int tmph = Integer.parseInt(this.endHour);
            if (tmph < 0 || tmph > 12) {
                errs.add("endHour", new ActionMessage("errors.range", (Object)this.endHour, (Object)1, (Object)12));
            }
        }
        catch (NumberFormatException nfe) {
            errs.add("endHour", new ActionMessage("errors.invalid.EndHour", (Object)this.endHour));
        }
        try {
            int tmpmin = Integer.parseInt(this.endMin);
            if (tmpmin > 59 || tmpmin < 0) {
                errs.add("endMin", new ActionMessage("errors.range", (Object)this.endMin, (Object)0, (Object)59));
            }
        }
        catch (NumberFormatException nfe) {
            errs.add("endMin", new ActionMessage("errors.invalid.EndMin", (Object)this.endMin));
        }
        Date tmpStartDate = this.getStartDate();
        Date tmpEndDate = this.getEndDate();
        if (tmpStartDate != null && tmpEndDate != null && tmpStartDate.after(tmpEndDate)) {
            errs.add("endDate", new ActionMessage("resource.common.monitor.error.FromEarlierThanTo"));
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append(" startMonth=").append(this.startMonth);
        buf.append(" startDay=").append(this.startDay);
        buf.append(" startYear=").append(this.startYear);
        buf.append(" startHour=").append(this.startHour);
        buf.append(" startMin=").append(this.startMin);
        buf.append(" startAmPm=").append(this.startAmPm);
        buf.append(" endMonth=").append(this.endMonth);
        buf.append(" endDay=").append(this.endDay);
        buf.append(" endYear=").append(this.endYear);
        buf.append(" endHour=").append(this.endHour);
        buf.append(" endMin=").append(this.endMin);
        buf.append(" endAmPm=").append(this.endAmPm);
        return buf.toString();
    }

    public boolean getWantEndDate() {
        return this.wantEndDate;
    }

    public void setWantEndDate(boolean b) {
        this.wantEndDate = b;
    }

    public Integer getEndDay() {
        return this.endDay;
    }

    public void setEndDay(Integer endDay) {
        this.endDay = endDay;
    }

    public Integer getEndMonth() {
        return this.endMonth;
    }

    public void setEndMonth(Integer endMonth) {
        this.endMonth = endMonth;
    }

    public Integer getEndYear() {
        return this.endYear;
    }

    public void setEndYear(Integer endYear) {
        this.endYear = endYear;
    }

    public String getEndMin() {
        return this.endMin;
    }

    public void setEndMin(String endMin) {
        this.endMin = endMin;
    }

    public String getEndHour() {
        return this.endHour;
    }

    public void setEndHour(String endHour) {
        this.endHour = endHour;
    }

    public Integer getStartDay() {
        return this.startDay;
    }

    public void setStartDay(Integer startDay) {
        this.startDay = startDay;
    }

    public String getStartAmPm() {
        return this.startAmPm;
    }

    public void setStartAmPm(String startAmPm) {
        this.startAmPm = startAmPm;
    }

    public String getEndAmPm() {
        return this.endAmPm;
    }

    public void setEndAmPm(String endAmPm) {
        this.endAmPm = endAmPm;
    }

    public Integer getStartYear() {
        return this.startYear;
    }

    public void setStartYear(Integer startYear) {
        this.startYear = startYear;
    }

    public String getStartMin() {
        return this.startMin;
    }

    public void setStartMin(String startMin) {
        this.startMin = startMin;
    }

    public String getStartHour() {
        return this.startHour;
    }

    public void setStartHour(String startHour) {
        this.startHour = startHour;
    }

    public Integer getStartMonth() {
        return this.startMonth;
    }

    public void setStartMonth(Integer startMonth) {
        this.startMonth = startMonth;
    }

    public Collection<Integer> getYearOptions() {
        int i;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        int year = cal.get(1);
        ArrayList<Integer> ret = new ArrayList<Integer>(11);
        for (i = 3; i > 0; --i) {
            ret.add(year + i);
        }
        for (i = 0; i < 8; ++i) {
            ret.add(year - i);
        }
        return ret;
    }
}

