/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.util.StringUtil;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricsControlAction;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricsDisplayForm;
import org.rhq.enterprise.gui.legacy.util.ActionUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.util.LookupUtil;

public class MetricsDisplayAction
extends MetricsControlAction {
    protected static final Log log = LogFactory.getLog(MetricsDisplayAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MetricsDisplayForm displayForm = (MetricsDisplayForm)form;
        Map forwardParams = displayForm.getForwardParams();
        Integer id = displayForm.getId();
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
        MeasurementBaselineManagerLocal baselineManager = LookupUtil.getMeasurementBaselineManager();
        if (displayForm.isCompareClicked()) {
            return this.returnCompare(request, mapping, forwardParams);
        }
        if (displayForm.isChartClicked()) {
            forwardParams.put("m", displayForm.getM());
            return this.returnChart(request, mapping, forwardParams);
        }
        if (displayForm.isThresholdClicked()) {
            Integer threshold = displayForm.getT();
            preferences.setMetricThresholdPreference(threshold);
            log.trace((Object)("saving threshold pref [" + threshold + "]"));
            LogFactory.getLog((String)"user.preferences").trace((Object)("Invoking setUserPrefs in MetricsDisplayAction  for " + user.getId() + " at " + System.currentTimeMillis() + " user.prefs = " + user.getWebPreferences()));
        } else if (displayForm.isUsersetClicked()) {
            Object[] m = displayForm.getM();
            if (m != null && m.length > 0) {
                MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
                Long begin = rangePreferences.begin;
                Long end = rangePreferences.end;
                Integer[] resourceIds = displayForm.getR();
                Object resources = null;
                log.trace((Object)("Set baselines in MetricsDisplayAction  for " + id + ": " + StringUtil.arrayToString((Object[])m)));
            }
            RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.monitor.confirm.MetricsBaselineSet");
        } else if (displayForm.isEnableClicked()) {
            Object[] m = displayForm.getM();
            if (m != null && m.length > 0) {
                Integer[] resources = displayForm.getR();
                baselineManager.enableAutoBaselineCalculation(subject, resources, (Integer[])m);
                log.trace((Object)("Enable auto baselines in MetricsDisplayAction  for " + id + ": " + StringUtil.arrayToString((Object[])m)));
            }
            RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.monitor.confirm.AutoBaselineSet");
        } else if (displayForm.isAddClicked()) {
            Integer[] m = displayForm.getM();
            if (m != null && m.length > 0) {
                LogFactory.getLog((String)"user.preferences").trace((Object)("Invoking setUserPrefs in MetricsDisplayAction  for " + user.getId() + " at " + System.currentTimeMillis() + " user.prefs = " + user.getWebPreferences()));
            }
            RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.monitor.confirm.FavoriteMetricsAdded");
        } else if (displayForm.isRemoveClicked()) {
            Integer[] m = displayForm.getM();
            if (m != null && m.length > 0) {
                LogFactory.getLog((String)"user.preferences").trace((Object)("Invoking setUserPrefs in MetricsDisplayAction  for " + user.getId() + " at " + System.currentTimeMillis() + " user.prefs = " + user.getWebPreferences()));
            }
            RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.monitor.confirm.FavoriteMetricsRemoved");
        }
        return super.execute(mapping, form, request, response);
    }

    private ActionForward returnCompare(HttpServletRequest request, ActionMapping mapping, Map params) throws Exception {
        String returnPath = ActionUtils.findReturnPath((ActionMapping)mapping, (Map)params);
        SessionUtils.setReturnPath((HttpSession)request.getSession(), (String)returnPath);
        return this.constructForward(request, mapping, "compare", params, false);
    }

    private ActionForward returnChart(HttpServletRequest request, ActionMapping mapping, Map params) throws Exception {
        String returnPath = ActionUtils.findReturnPath((ActionMapping)mapping, (Map)params);
        SessionUtils.setReturnPath((HttpSession)request.getSession(), (String)returnPath);
        return this.constructForward(request, mapping, "chart", params, false);
    }

    private void addFavoriteMetrics(Integer[] selectedIds, WebUserPreferences preferences, String entityType) throws IllegalArgumentException {
        WebUserPreferences.FavoriteResourcePortletPreferences prefs = preferences.getFavoriteResourcePortletPreferences();
        for (Integer resourceIdToAdd : selectedIds) {
            if (prefs.isFavorite(resourceIdToAdd.intValue())) continue;
            prefs.addFavorite(resourceIdToAdd.intValue());
        }
        preferences.setFavoriteResourcePortletPreferences(prefs);
    }

    private void removeFavoriteMetrics(Integer[] selectedIds, WebUserPreferences preferences, String entityType) throws IllegalArgumentException {
        WebUserPreferences.FavoriteResourcePortletPreferences prefs = preferences.getFavoriteResourcePortletPreferences();
        for (Integer resourceIdToAdd : selectedIds) {
            prefs.removeFavorite(resourceIdToAdd.intValue());
        }
        preferences.setFavoriteResourcePortletPreferences(prefs);
    }
}

