/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.agentupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.core.domain.common.composite.SystemSettings;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class AgentUpdateServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static String SYSPROP_AGENT_DOWNLOADS_LIMIT = "rhq.server.agent-downloads-limit";
    private static int DEFAULT_AGENT_DOWNLOADS_LIMIT = 45;
    private static final int ERROR_CODE_AGENT_UPDATE_DISABLED = 403;
    private static final int ERROR_CODE_TOO_MANY_DOWNLOADS = 503;
    private AtomicInteger numActiveDownloads = null;
    private Log log = LogFactory.getLog(this.getClass());
    private AgentManagerLocal agentManager = null;
    private boolean initialized = false;

    public void init() throws ServletException {
        this.log.info((Object)"Starting the RHQ agent update servlet");
        this.numActiveDownloads = new AtomicInteger(0);
    }

    private synchronized void loadAgentUpdateBinaryInfo() throws ServletException {
        if (!this.initialized) {
            this.log.info((Object)"RHQ agent update servlet is looking up binary file information...");
            try {
                this.log.info((Object)("Agent Update Binary File: " + this.getAgentUpdateBinaryFile()));
            }
            catch (Throwable t) {
                this.log.error((Object)"Missing agent update binary file - agents will not be able to update", t);
            }
            try {
                File versionFile = this.getAgentUpdateVersionFile();
                this.log.debug((Object)(versionFile + ": " + new String(StreamUtil.slurp((InputStream)new FileInputStream(versionFile)))));
            }
            catch (Throwable t) {
                this.log.error((Object)"Cannot determine the agent version information - agents will not be able to update.", t);
            }
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.loadAgentUpdateBinaryInfo();
        this.disableBrowserCache(resp);
        String servletPath = req.getServletPath();
        if (servletPath != null) {
            if (this.isServerAcceptingRequests()) {
                if (servletPath.endsWith("version")) {
                    this.getVersion(req, resp);
                } else if (servletPath.endsWith("download")) {
                    try {
                        this.numActiveDownloads.incrementAndGet();
                        this.getDownload(req, resp);
                    }
                    finally {
                        this.numActiveDownloads.decrementAndGet();
                    }
                } else {
                    resp.sendError(400, "Invalid servlet path [" + servletPath + "] - please contact administrator");
                }
            } else {
                this.sendErrorServerNotAcceptingRequests(resp);
            }
        } else {
            resp.sendError(400, "Invalid servlet path - please contact administrator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDownload(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int limit = this.getDownloadLimit();
        if (limit <= 0) {
            this.sendErrorAgentUpdateDisabled(resp);
            return;
        }
        if (limit < this.numActiveDownloads.get()) {
            this.sendErrorTooManyDownloads(resp);
            return;
        }
        try {
            File agentJar = this.getAgentUpdateBinaryFile();
            resp.setContentType("application/octet-stream");
            resp.setHeader("Content-Disposition", "attachment; filename=" + agentJar.getName());
            resp.setContentLength((int)agentJar.length());
            resp.setDateHeader("Last-Modified", agentJar.lastModified());
            FileInputStream agentJarStream = new FileInputStream(agentJar);
            try {
                StreamUtil.copy((InputStream)agentJarStream, (OutputStream)resp.getOutputStream(), (boolean)false);
            }
            finally {
                agentJarStream.close();
            }
        }
        catch (Throwable t) {
            String clientAddr = this.getClientAddress(req);
            this.log.error((Object)("Failed to stream agent jar to remote client [" + clientAddr + "]: " + ThrowableUtil.getAllMessages((Throwable)t)));
            this.disableBrowserCache(resp);
            resp.sendError(500, "Failed to stream agent jar");
        }
    }

    private void getVersion(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            File versionFile = this.getAgentUpdateVersionFile();
            resp.setContentType("text/plain");
            resp.setDateHeader("Last-Modified", versionFile.lastModified());
            FileInputStream stream = new FileInputStream(versionFile);
            byte[] versionData = StreamUtil.slurp((InputStream)stream);
            resp.getOutputStream().write(versionData);
        }
        catch (Throwable t) {
            String clientAddr = this.getClientAddress(req);
            this.log.error((Object)("Failed to stream version info to remote client [" + clientAddr + "]: " + ThrowableUtil.getAllMessages((Throwable)t)));
            this.disableBrowserCache(resp);
            resp.sendError(500, "Failed to stream version info");
        }
    }

    private int getDownloadLimit() {
        int limit;
        SystemSettings systemConfig = LookupUtil.getSystemManager().getSystemSettings(LookupUtil.getSubjectManager().getOverlord());
        if (!Boolean.parseBoolean((String)systemConfig.get((Object)SystemSetting.AGENT_AUTO_UPDATE_ENABLED))) {
            return 0;
        }
        String limitStr = System.getProperty(SYSPROP_AGENT_DOWNLOADS_LIMIT);
        try {
            limit = Integer.parseInt(limitStr);
        }
        catch (Exception e) {
            limit = DEFAULT_AGENT_DOWNLOADS_LIMIT;
            this.log.warn((Object)("Agent downloads limit system property [" + SYSPROP_AGENT_DOWNLOADS_LIMIT + "] is either not set or invalid [" + limitStr + "] - limit will be [" + limit + "]."));
        }
        return limit;
    }

    private void disableBrowserCache(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-cache, no-store");
        resp.setHeader("Expires", "-1");
        resp.setHeader("Pragma", "no-cache");
    }

    private void sendErrorServerNotAcceptingRequests(HttpServletResponse resp) throws IOException {
        this.disableBrowserCache(resp);
        resp.sendError(403, "Server Is Down For Maintenance");
    }

    private void sendErrorAgentUpdateDisabled(HttpServletResponse resp) throws IOException {
        this.disableBrowserCache(resp);
        resp.sendError(403, "Agent Updates Has Been Disabled");
    }

    private void sendErrorTooManyDownloads(HttpServletResponse resp) throws IOException {
        this.disableBrowserCache(resp);
        resp.setHeader("Retry-After", "30");
        resp.sendError(503, "Maximum limit exceeded - download agent later");
    }

    private File getAgentUpdateVersionFile() throws Exception {
        return this.getAgentManager().getAgentUpdateVersionFile();
    }

    private File getAgentUpdateBinaryFile() throws Exception {
        return this.getAgentManager().getAgentUpdateBinaryFile();
    }

    private AgentManagerLocal getAgentManager() {
        if (this.agentManager == null) {
            this.agentManager = LookupUtil.getAgentManager();
        }
        return this.agentManager;
    }

    private boolean isServerAcceptingRequests() {
        try {
            Server.OperationMode mode = LookupUtil.getServerManager().getServer().getOperationMode();
            return mode == Server.OperationMode.NORMAL;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getClientAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if ((ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) && ((ip = request.getHeader("HTTP_X_FORWARDED_FOR")) == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip))) {
            ip = String.format("%s (%s)", request.getRemoteHost(), request.getRemoteAddr());
        }
        return ip;
    }
}

