/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.paging;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.util.PageControl;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;

public class PageControlELResolver
extends ELResolver {
    private final Log log = LogFactory.getLog(this.getClass());

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        Class result = null;
        if (context == null) {
            throw new NullPointerException("ELContext was null for getType method in PageControlELResolver");
        }
        if (base != null && (base.equals(PageControlView.class) || base instanceof PageControlView)) {
            String propertyName = property.toString().toLowerCase();
            if ("pagesize".equals(propertyName)) {
                result = Integer.class;
            } else if ("pagenumber".equals(propertyName)) {
                result = Integer.class;
            } else if ("unlimited".equals(propertyName)) {
                result = Boolean.class;
            } else {
                throw new PropertyNotWritableException("Only the pageSize and pageNumber properties of a PageControl object can be resolved");
            }
            context.setPropertyResolved(true);
        }
        return result;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException("ELContext was null for getValue method in PageControlELResolver");
        }
        Object result = null;
        if (base == null) {
            String propertyName = (String)property;
            if ("PageControl".equals(propertyName)) {
                result = PageControlView.class;
                context.setPropertyResolved(true);
            }
        } else if (PageControlView.class.equals(base)) {
            String viewName = property.toString();
            result = PageControlView.valueOf((String)viewName);
            context.setPropertyResolved(true);
        } else if (base instanceof PageControlView) {
            PageControlView view = (PageControlView)base;
            String methodName = (String)property;
            String lowerCaseMethodName = methodName.toLowerCase();
            this.log.debug((Object)("accessing PageControl." + methodName));
            if ("pagesize".equals(lowerCaseMethodName)) {
                WebUser user = EnterpriseFacesContextUtility.getWebUser();
                WebUserPreferences preferences = user.getWebPreferences();
                PageControl pc = preferences.getPageControl(view);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Getting PageControlView[" + view + "] to " + pc));
                }
                result = pc.getPageSize();
            } else if ("pagenumber".equals(lowerCaseMethodName)) {
                WebUser user = EnterpriseFacesContextUtility.getWebUser();
                WebUserPreferences preferences = user.getWebPreferences();
                PageControl pc = preferences.getPageControl(view);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Getting PageControlView[" + view + "] to " + pc));
                }
                result = pc.getPageNumber() + 1;
            } else if ("unlimited".equals(lowerCaseMethodName)) {
                result = view.isUnlimited();
            } else {
                throw new PropertyNotFoundException("The " + methodName + " property of a PageControl object is not accessible");
            }
            context.setPropertyResolved(true);
        }
        return result;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException("ELContext was null for setValue method in PageControlELResolver");
        }
        if (base instanceof PageControlView) {
            PageControlView view = (PageControlView)base;
            String methodName = (String)property;
            String lowerCaseMethodName = methodName.toLowerCase();
            if ("pagesize".equals(lowerCaseMethodName)) {
                if (value != null) {
                    WebUser user = EnterpriseFacesContextUtility.getWebUser();
                    WebUserPreferences preferences = user.getWebPreferences();
                    PageControl pc = preferences.getPageControl(view);
                    int pageSize = (Integer)value;
                    if (pc.getPageSize() == pageSize) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("PageControlView[" + view + "] needs no changes " + pc));
                        }
                    } else {
                        pc.setPageSize(pageSize);
                        pc.setPageNumber(0);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Setting PageControlView[" + view + "] to " + pc));
                        }
                        preferences.setPageControl(view, pc);
                    }
                }
                context.setPropertyResolved(true);
            } else if ("pagenumber".equals(lowerCaseMethodName)) {
                if (value != null) {
                    WebUser user = EnterpriseFacesContextUtility.getWebUser();
                    WebUserPreferences preferences = user.getWebPreferences();
                    PageControl pc = preferences.getPageControl(view);
                    int pageNumber = (Integer)value;
                    pc.setPageNumber(pageNumber - 1);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Setting PageControlView[" + view + "] to " + pc));
                    }
                    preferences.setPageControl(view, pc);
                }
                context.setPropertyResolved(true);
            } else {
                throw new PropertyNotFoundException("The " + methodName + " property of a PageControl object can not be set, only pageSize");
            }
        }
    }
}

