/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.rhq.enterprise.gui.legacy.Portal;
import org.rhq.enterprise.gui.legacy.exception.ParameterNotFoundException;
import org.rhq.enterprise.gui.legacy.util.ActionUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;

public abstract class BaseDispatchAction
extends DispatchAction {
    private static Log log = LogFactory.getLog((String)BaseDispatchAction.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parameter = mapping.getParameter();
        if (parameter == null) {
            throw new ServletException("no dispatch parameter configured");
        }
        String name = request.getParameter(parameter);
        if (name == null) {
            throw new ServletException("dispatch parameter [" + parameter + "] not found");
        }
        name = name.replaceAll("<", "&lt;").replaceAll("\"", "&quot;").replaceAll(">", "&gt;").replaceAll("&", "&amp;").replaceAll("'", "&#x27;").replaceAll("/", "&#x2F;");
        String methodName = this.getKeyMethodMap().getProperty(name);
        if (methodName == null) {
            throw new ServletException("dispatch method for key [" + name + "] not found");
        }
        ActionForward fwd = this.dispatchMethod(mapping, form, request, response, methodName);
        try {
            Portal tmpPortal = (Portal)request.getAttribute("portal");
            if (tmpPortal.doWorkflow()) {
                HashMap<String, String> params = tmpPortal.getWorkflowParams();
                if (params == null) {
                    params = new HashMap<String, String>();
                    params.put("mode", name);
                }
                this.setReturnPath(request, mapping, params);
            }
        }
        catch (ServletException e) {
            log.debug((Object)"Could not save return path: ", (Throwable)e);
        }
        catch (ParameterNotFoundException pne) {
            log.debug((Object)("Could not save return path: " + (Object)((Object)pne)));
        }
        return fwd;
    }

    protected abstract Properties getKeyMethodMap();

    protected void setReturnPath(HttpServletRequest request, ActionMapping mapping, Map params) throws Exception {
        String returnPath = ActionUtils.findReturnPath((ActionMapping)mapping, (Map)params);
        if (log.isTraceEnabled()) {
            log.trace((Object)("setting return path: " + returnPath));
        }
        SessionUtils.setReturnPath((HttpSession)request.getSession(), (String)returnPath);
    }

    protected void setReturnPath(HttpServletRequest request, ActionMapping mapping) throws Exception {
        this.setReturnPath(request, mapping, new HashMap());
    }
}

