/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postfix;

import net.augeas.Augeas;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.augeas.AugeasConfigurationComponent;
import org.rhq.plugins.augeas.helper.AugeasNode;

public class PostfixServerComponent
extends AugeasConfigurationComponent {
    private ProcessInfo processInfo;

    public void start(ResourceContext resourceContext) throws Exception {
        super.start(resourceContext);
        this.processInfo = resourceContext.getNativeProcess();
    }

    public void stop() {
        this.processInfo = null;
        super.stop();
    }

    public AvailabilityType getAvailability() {
        ProcessInfo.ProcessInfoSnapshot processInfoSnapshot = this.getProcessInfoSnapshot();
        return processInfoSnapshot != null && processInfoSnapshot.isRunning() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    private ProcessInfo.ProcessInfoSnapshot getProcessInfoSnapshot() {
        ProcessInfo.ProcessInfoSnapshot processInfoSnapshot;
        ProcessInfo.ProcessInfoSnapshot processInfoSnapshot2 = processInfoSnapshot = this.processInfo == null ? null : this.processInfo.freshSnapshot();
        if (processInfoSnapshot == null || !processInfoSnapshot.isRunning()) {
            this.processInfo = this.getResourceContext().getNativeProcess();
            processInfoSnapshot = this.processInfo == null ? null : this.processInfo.priorSnaphot();
        }
        return processInfoSnapshot;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        return super.loadResourceConfiguration();
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        super.updateResourceConfiguration(report);
    }

    protected Object toPropertyValue(PropertyDefinitionSimple propDefSimple, Augeas augeas, AugeasNode node) {
        if (propDefSimple.getType().equals((Object)PropertySimpleType.BOOLEAN)) {
            return "yes".equals(augeas.get(node.getPath()));
        }
        return super.toPropertyValue(propDefSimple, augeas, node);
    }

    protected String toNodeValue(Augeas augeas, AugeasNode node, PropertyDefinitionSimple propDefSimple, PropertySimple propSimple) {
        if (propDefSimple.getType().equals((Object)PropertySimpleType.BOOLEAN)) {
            if (propSimple.getBooleanValue().booleanValue()) {
                return "yes";
            }
            return "no";
        }
        return super.toNodeValue(augeas, node, propDefSimple, propSimple);
    }
}

