/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.postgres.PostgresServerComponent;
import org.rhq.plugins.postgres.PostgresTableDiscoveryComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresUserDiscoveryComponent
implements ResourceDiscoveryComponent<PostgresServerComponent> {
    private static final Log log = LogFactory.getLog(PostgresTableDiscoveryComponent.class);
    public static final String USERS_QUERY = "select * from pg_roles";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PostgresServerComponent> context) throws Exception {
        log.info((Object)"Discovering postgres users");
        HashSet<DiscoveredResourceDetails> discoveredUsers = new HashSet<DiscoveredResourceDetails>();
        Connection connection = ((PostgresServerComponent)context.getParentResourceComponent()).getConnection();
        if (connection == null) {
            return discoveredUsers;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(USERS_QUERY);
            while (resultSet.next()) {
                String userName = resultSet.getString("rolname");
                DiscoveredResourceDetails service = new DiscoveredResourceDetails(context.getResourceType(), userName, userName + " User", null, "A Postgres user", null, null);
                service.getPluginConfiguration().put((Property)new PropertySimple("userName", (Object)userName));
                discoveredUsers.add(service);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose((Statement)statement, resultSet);
            throw throwable;
        }
        JDBCUtil.safeClose((Statement)statement, (ResultSet)resultSet);
        return discoveredUsers;
    }
}

